/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacococoveragecolumn;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacococoveragecolumn.CoverageRange;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.awt.Color;
import java.math.BigDecimal;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaCoCoColumn
extends ListViewColumn {
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JaCoCoColumn() {
    }

    public boolean hasCoverage(Job<?, ?> job) {
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        if (lastSuccessfulBuild == null) {
            return false;
        }
        return lastSuccessfulBuild.getAction(JacocoBuildAction.class) != null;
    }

    public String getPercent(Job<?, ?> job) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.hasCoverage(job)) {
            stringBuilder.append("N/A");
        } else {
            Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
            Double percent = this.getLinePercent(lastSuccessfulBuild);
            stringBuilder.append(percent);
        }
        return stringBuilder.toString();
    }

    public String getLineColor(Job<?, ?> job, BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        if (job != null && !this.hasCoverage(job)) {
            return CoverageRange.NA.getLineHexString();
        }
        return CoverageRange.valueOf(amount.doubleValue()).getLineHexString();
    }

    public String getFillColor(Job<?, ?> job, BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        if (job != null && !this.hasCoverage(job)) {
            return CoverageRange.NA.getFillHexString();
        }
        Color c = CoverageRange.fillColorOf(amount.doubleValue());
        return CoverageRange.colorAsHexString(c);
    }

    public BigDecimal getLineCoverage(Job<?, ?> job) {
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        return BigDecimal.valueOf(this.getLinePercent(lastSuccessfulBuild));
    }

    private Double getLinePercent(Run<?, ?> lastSuccessfulBuild) {
        Float percentageFloat = this.getPercentageFloat(lastSuccessfulBuild);
        double doubleValue = percentageFloat.doubleValue();
        int decimalPlaces = 2;
        BigDecimal bigDecimal = new BigDecimal(doubleValue);
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    private Float getPercentageFloat(Run<?, ?> lastSuccessfulBuild) {
        if (lastSuccessfulBuild == null) {
            return new Float(0.0f);
        }
        JacocoBuildAction action = (JacocoBuildAction)lastSuccessfulBuild.getAction(JacocoBuildAction.class);
        if (action == null) {
            return new Float(0.0f);
        }
        Coverage ratio = action.getLineCoverage();
        return Float.valueOf(ratio.getPercentageFloat());
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    private static class DescriptorImpl
    extends ListViewColumnDescriptor {
        private DescriptorImpl() {
        }

        public ListViewColumn newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new JaCoCoColumn();
        }

        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return "JaCoCo Line Coverage";
        }
    }
}

