/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAnnotator {
    private final File src;

    public SourceAnnotator(File src) {
        this.src = src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines() {
        ArrayList<String> aList = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.src));
            while ((line = br.readLine()) != null) {
                aList.add(line.replaceAll("\\t", "&nbsp&nbsp&nbsp&nbsp").replaceAll("<", "&lt").replaceAll(">", "&gt"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return aList;
    }

    public void printHighlightedSrcFile(ISourceNode cov, Writer output) {
        StringBuilder buf = new StringBuilder();
        try {
            List<String> sourceLines = this.readLines();
            output.write("<code style=\"white-space:pre;\">");
            for (int i = 1; i <= sourceLines.size(); ++i) {
                buf.setLength(0);
                ILine line = cov.getLine(i);
                ICounter branches = line.getBranchCounter();
                int status = line.getStatus();
                if (status != 0) {
                    this.printHighlightedLine(buf, i, branches, sourceLines.get(i - 1), status);
                } else {
                    buf.append(i + ": ").append(sourceLines.get(i - 1)).append("<br>");
                }
                output.write(buf.toString());
            }
            output.write("</code>");
        }
        catch (IOException e) {
            buf.append("ERROR: Error while reading the sourcefile!");
        }
    }

    private void printHighlightedLine(StringBuilder buf, int lineNumber, ICounter cov, String sourceLine, int status) {
        buf.append(lineNumber + ":");
        String tooltip = this.getTooltip(cov);
        if (tooltip != null) {
            buf.append("\u2022<SPAN title=\"").append(tooltip).append("\"");
        } else {
            buf.append(" <SPAN");
        }
        buf.append(" style=\"BACKGROUND-COLOR: " + this.getStatusColor(status) + "\">").append(sourceLine).append("</SPAN>").append("<br>");
    }

    private String getTooltip(ICounter cov) {
        switch (cov.getStatus()) {
            case 2: {
                return "All " + cov.getTotalCount() + " branches covered.";
            }
            case 3: {
                return cov.getMissedCount() + " of " + cov.getTotalCount() + " branches missed.";
            }
            case 1: {
                return "All " + cov.getTotalCount() + " branches missed.";
            }
        }
        return null;
    }

    private String getStatusColor(int status) {
        switch (status) {
            case 2: {
                return "#ccffcc";
            }
            case 3: {
                return "#ffff80";
            }
            case 1: {
                return "#ffaaaa";
            }
        }
        return "none";
    }
}

