/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.report.AggregatedReport;
import hudson.plugins.jacoco.report.ClassReport;
import hudson.plugins.jacoco.report.SourceAnnotator;
import hudson.plugins.jacoco.report.SourceFileReport;
import java.io.Writer;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.ISourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodReport
extends AggregatedReport<ClassReport, MethodReport, SourceFileReport> {
    private IMethodCoverage methodCov;

    @Override
    public String printFourCoverageColumns() {
        StringBuilder buf = new StringBuilder();
        this.instruction.setType(CoverageElement.Type.INSTRUCTION);
        this.complexity.setType(CoverageElement.Type.COMPLEXITY);
        this.branch.setType(CoverageElement.Type.BRANCH);
        this.line.setType(CoverageElement.Type.LINE);
        this.method.setType(CoverageElement.Type.METHOD);
        this.printRatioCell(this.isFailed(), this.instruction, buf);
        this.printRatioCell(this.isFailed(), this.branch, buf);
        this.printRatioCell(this.isFailed(), this.complexity, buf);
        this.printRatioCell(this.isFailed(), this.line, buf);
        this.printRatioCell(this.isFailed(), this.method, buf);
        return buf.toString();
    }

    @Override
    public void add(SourceFileReport child) {
        String newChildName = child.getName().replaceAll(this.getName() + ".", "");
        child.setName(newChildName);
        this.getChildren().put(child.getName(), child);
        this.hasClassCoverage();
    }

    @Override
    public boolean hasClassCoverage() {
        return false;
    }

    public void setSrcFileInfo(IMethodCoverage methodCov) {
        this.methodCov = methodCov;
    }

    public void printHighlightedSrcFile(Writer output) {
        new SourceAnnotator(((ClassReport)this.getParent()).getSourceFilePath()).printHighlightedSrcFile((ISourceNode)this.methodCov, output);
    }
}

