/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.model.AbstractBuild;
import hudson.plugins.jacoco.ExecutionFileLoader;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.JacocoHealthReportThresholds;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.report.AggregatedReport;
import hudson.plugins.jacoco.report.ClassReport;
import hudson.plugins.jacoco.report.MethodReport;
import hudson.plugins.jacoco.report.PackageReport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageReport
extends AggregatedReport<CoverageReport, CoverageReport, PackageReport> {
    private final JacocoBuildAction action;
    public JacocoHealthReportThresholds healthReports;
    static NumberFormat dataFormat = new DecimalFormat("000.00", new DecimalFormatSymbols(Locale.US));
    static NumberFormat percentFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    static NumberFormat intFormat = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));

    private CoverageReport(JacocoBuildAction action) {
        this.action = action;
        this.setName("Jacoco");
    }

    public CoverageReport(JacocoBuildAction action, ExecutionFileLoader executionFileLoader) {
        this(action);
        try {
            action.logger.println("[JaCoCo plugin] Loading packages..");
            if (executionFileLoader.getBundleCoverage() != null) {
                this.setAllCovTypes(this, (ICoverageNode)executionFileLoader.getBundleCoverage());
                ArrayList packageList = new ArrayList(executionFileLoader.getBundleCoverage().getPackages());
                for (IPackageCoverage packageCov : packageList) {
                    PackageReport packageReport = new PackageReport();
                    packageReport.setName(packageCov.getName());
                    packageReport.setParent(this);
                    this.setCoverage(packageReport, (ICoverageNode)packageCov);
                    ArrayList classList = new ArrayList(packageCov.getClasses());
                    for (IClassCoverage classCov : classList) {
                        ClassReport classReport = new ClassReport();
                        classReport.setName(classCov.getName());
                        classReport.setParent(packageReport);
                        classReport.setSrcFileInfo(classCov, executionFileLoader.getSrcDir() + "/" + packageCov.getName() + "/" + classCov.getSourceFileName());
                        packageReport.setCoverage(classReport, (ICoverageNode)classCov);
                        ArrayList methodList = new ArrayList(classCov.getMethods());
                        for (IMethodCoverage methodCov : methodList) {
                            MethodReport methodReport = new MethodReport();
                            methodReport.setName(this.getMethodName(classCov, methodCov));
                            methodReport.setParent(classReport);
                            classReport.setCoverage(methodReport, (ICoverageNode)methodCov);
                            methodReport.setSrcFileInfo(methodCov);
                            classReport.add(methodReport);
                        }
                        packageReport.add(classReport);
                    }
                    this.add(packageReport);
                }
            }
            action.logger.println("[JaCoCo plugin] Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isAnonymous(String vmname) {
        int dollarPosition = vmname.lastIndexOf(36);
        if (dollarPosition == -1) {
            return false;
        }
        int internalPosition = dollarPosition + 1;
        if (internalPosition == vmname.length()) {
            return false;
        }
        char start = vmname.charAt(internalPosition);
        return !Character.isJavaIdentifierStart(start);
    }

    private String getMethodName(IClassCoverage classCov, IMethodCoverage methodCov) {
        if ("<clinit>".equals(methodCov.getName())) {
            return "static {...}";
        }
        StringBuilder sb = new StringBuilder();
        if ("<init>".equals(methodCov.getName())) {
            if (this.isAnonymous(classCov.getName())) {
                return "{...}";
            }
            int pos = classCov.getName().lastIndexOf(47);
            String name = pos == -1 ? classCov.getName() : classCov.getName().substring(pos + 1);
            sb.append(name.replace('$', '.'));
        } else {
            sb.append(methodCov.getName());
        }
        sb.append('(');
        Type[] arguments = Type.getArgumentTypes((String)methodCov.getDesc());
        boolean comma = false;
        for (Type arg : arguments) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            String name = arg.getClassName();
            int pos = name.lastIndexOf(46);
            String shortname = pos == -1 ? name : name.substring(pos + 1);
            sb.append(shortname.replace('$', '.'));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    protected void printRatioCell(boolean failed, Coverage ratio, StringBuilder buf) {
        if (ratio != null && ratio.isInitialized()) {
            String bgColor = "#FFFFFF";
            if (JacocoHealthReportThresholds.RESULT.BETWEENMINMAX == this.healthReports.getResultByTypeAndRatio(ratio)) {
                bgColor = "#FF8000";
            } else if (JacocoHealthReportThresholds.RESULT.BELLOWMINIMUM == this.healthReports.getResultByTypeAndRatio(ratio)) {
                bgColor = "#FF0000";
            }
            buf.append("<td bgcolor=\" " + bgColor + " \" class='").append("").append("'");
            buf.append(" data='").append(dataFormat.format(ratio.getPercentageFloat()));
            buf.append("'>\n");
            this.printRatioTable(ratio, buf);
            buf.append("</td>\n");
        }
    }

    @Override
    protected void printRatioTable(Coverage ratio, StringBuilder buf) {
        String numerator = intFormat.format(ratio.getMissed());
        String denominator = intFormat.format(ratio.getCovered());
        buf.append("<table class='percentgraph' cellpadding='0px' cellspacing='0px'><tr class='percentgraph'>").append("<td width='40px' class='data'>").append(ratio.getPercentage()).append("%</td>").append("<td class='percentgraph'>").append("<div class='percentgraph' style='width: ").append(100).append("px;'>").append("<div class='redbar' style='width: ").append((float)ratio.getMissed() / (float)(ratio.getMissed() + ratio.getCovered()) * 100.0f).append("px;'>").append("</div></div></td></tr><tr>").append("<span class='text'>").append("<b>M:</b> " + numerator).append(" ").append("<b>C:</b> " + denominator).append("</span></tr>").append("</table>");
    }

    @Override
    public CoverageReport getPreviousResult() {
        JacocoBuildAction prev = this.action.getPreviousResult();
        if (prev != null) {
            return prev.getResult();
        }
        return null;
    }

    @Override
    public AbstractBuild<?, ?> getBuild() {
        return this.action.owner;
    }

    @WebMethod(name={"jacoco.exec"})
    public HttpResponse doJacocoExec() throws IOException {
        final List<File> files = this.action.getJacocoReport().getExecFiles();
        switch (files.size()) {
            case 0: {
                return HttpResponses.error((int)404, (String)"No jacoco.exec file recorded");
            }
            case 1: {
                return HttpResponses.staticResource((URL)files.get(0).toURI().toURL());
            }
        }
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                ExecFileLoader loader = new ExecFileLoader();
                for (File exec : files) {
                    loader.load(exec);
                }
                rsp.setContentType("application/octet-stream");
                ExecutionDataWriter dataWriter = new ExecutionDataWriter((OutputStream)rsp.getOutputStream());
                loader.getSessionInfoStore().accept((ISessionInfoVisitor)dataWriter);
                loader.getExecutionDataStore().accept((IExecutionDataVisitor)dataWriter);
            }
        };
    }

    public void setThresholds(JacocoHealthReportThresholds healthReports) {
        this.healthReports = healthReports;
    }
}

