/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet.utils;

import hudson.model.Job;
import hudson.model.Run;
import java.math.BigDecimal;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static int validateChartAttributes(String attribute, int defaultValue) {
        if (attribute != null) {
            if (attribute.equals("") || attribute.equals("0")) {
                return defaultValue;
            }
            try {
                int validAttributeValue = Integer.parseInt(attribute);
                if (validAttributeValue < 0) {
                    return defaultValue;
                }
                return validAttributeValue;
            }
            catch (NumberFormatException exception) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static LocalDate getLastDate(List<Job> jobs) {
        LocalDate lastDate = null;
        for (Job job : jobs) {
            Run lastRun = job.getLastBuild();
            if (lastRun == null) continue;
            LocalDate date = new LocalDate((Object)lastRun.getTimestamp());
            if (lastDate == null) {
                lastDate = date;
            }
            if (!date.isAfter((ReadablePartial)lastDate)) continue;
            lastDate = date;
        }
        return lastDate;
    }

    public static float roundFLoat(int scale, int roundingMode, float value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(scale, roundingMode);
        return bigDecimal.floatValue();
    }

    public static int nthOccurrence(String str, char c, int n) {
        int pos = str.indexOf(c, 0);
        while (n-- > 0 && pos != -1) {
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }
}

