/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.plugins.jacoco.ExecutionFileLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacocoReportDir {
    private final File root;

    public JacocoReportDir(AbstractBuild<?, ?> build) {
        this.root = new File(build.getRootDir(), "jacoco");
    }

    public File getClassesDir() {
        return new File(this.root, "classes");
    }

    public void saveClassesFrom(FilePath dir) throws IOException, InterruptedException {
        FilePath d = new FilePath(this.getClassesDir());
        d.mkdirs();
        dir.copyRecursiveTo(d);
    }

    public File getSourcesDir() {
        return new File(this.root, "sources");
    }

    public void saveSourcesFrom(FilePath dir) throws IOException, InterruptedException {
        FilePath d = new FilePath(this.getSourcesDir());
        d.mkdirs();
        dir.copyRecursiveTo(d);
    }

    public File getExecFilesDir() {
        return new File(this.root, "execFiles");
    }

    public List<File> getExecFiles() {
        File checkPath;
        ArrayList<File> r = new ArrayList<File>();
        int i = 0;
        File root = this.getExecFilesDir();
        while ((checkPath = new File(root, "exec" + i)).exists()) {
            r.add(new File(checkPath, "jacoco.exec"));
            ++i;
        }
        return r;
    }

    public void addExecFiles(Iterable<FilePath> execFiles) throws IOException, InterruptedException {
        FilePath root = new FilePath(this.getExecFilesDir());
        int i = 0;
        for (FilePath file : execFiles) {
            FilePath separateExecDir;
            while ((separateExecDir = new FilePath(root, "exec" + i++)).exists()) {
            }
            FilePath fullExecName = separateExecDir.child("jacoco.exec");
            file.copyTo(fullExecName);
        }
    }

    public ExecutionFileLoader parse(String[] includes, String[] excludes) throws IOException {
        ExecutionFileLoader efl = new ExecutionFileLoader();
        for (File exec : this.getExecFiles()) {
            efl.addExecFile(new FilePath(exec));
        }
        efl.setIncludes(includes);
        efl.setExcludes(excludes);
        efl.setClassDir(new FilePath(this.getClassesDir()));
        efl.setSrcDir(new FilePath(this.getSourcesDir()));
        efl.loadBundleCoverage();
        return efl;
    }

    public String toString() {
        return this.root.toString();
    }
}

