/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacococoveragecolumn;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacococoveragecolumn.CoverageRange;
import hudson.views.ListViewColumn;
import java.awt.Color;
import java.math.BigDecimal;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaCoCoColumn
extends ListViewColumn {
    @Extension
    public static final Descriptor<ListViewColumn> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JaCoCoColumn() {
    }

    public String getPercent(Job<?, ?> job) {
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        StringBuilder stringBuilder = new StringBuilder();
        if (lastSuccessfulBuild == null) {
            stringBuilder.append("N/A");
        } else if (lastSuccessfulBuild.getAction(JacocoBuildAction.class) == null) {
            stringBuilder.append("N/A");
        } else {
            Double percent = this.getLinePercent(lastSuccessfulBuild);
            stringBuilder.append(percent);
        }
        return stringBuilder.toString();
    }

    public String getLineColor(BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        return CoverageRange.valueOf(amount.doubleValue()).getLineHexString();
    }

    public String getFillColor(BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        Color c = CoverageRange.fillColorOf(amount.doubleValue());
        return CoverageRange.colorAsHexString(c);
    }

    public BigDecimal getLineCoverage(Job<?, ?> job) {
        Run lastSuccessfulBuild = job.getLastSuccessfulBuild();
        return BigDecimal.valueOf(this.getLinePercent(lastSuccessfulBuild));
    }

    private Double getLinePercent(Run<?, ?> lastSuccessfulBuild) {
        Float percentageFloat = this.getPercentageFloat(lastSuccessfulBuild);
        double doubleValue = percentageFloat.doubleValue();
        int decimalPlaces = 2;
        BigDecimal bigDecimal = new BigDecimal(doubleValue);
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    private Float getPercentageFloat(Run<?, ?> lastSuccessfulBuild) {
        if (lastSuccessfulBuild == null) {
            return new Float(0.0f);
        }
        JacocoBuildAction action = (JacocoBuildAction)lastSuccessfulBuild.getAction(JacocoBuildAction.class);
        if (action == null) {
            return new Float(0.0f);
        }
        Coverage ratio = action.getLineCoverage();
        return Float.valueOf(ratio.getPercentageFloat());
    }

    public Descriptor<ListViewColumn> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescriptorImpl
    extends Descriptor<ListViewColumn> {
        private DescriptorImpl() {
        }

        public ListViewColumn newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new JaCoCoColumn();
        }

        public String getDisplayName() {
            return "JaCoCo Line Coverage";
        }
    }
}

