/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacococoveragecolumn;

import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CoverageRange {
    PERFECT(100.0, new Color(0, 139, 0), new Color(238, 238, 238)),
    EXCELLENT(97.0, new Color(0, 205, 0), new Color(0, 0, 0)),
    GOOD(92.0, new Color(122, 255, 63), new Color(0, 0, 0)),
    SUFFICIENT(85.0, new Color(200, 255, 63), new Color(0, 0, 0)),
    FAIR(75.0, new Color(255, 255, 0), new Color(0, 0, 0)),
    POOR(50.0, new Color(255, 127, 0), new Color(0, 0, 0)),
    TRAGIC(25.0, new Color(255, 0, 0), new Color(238, 238, 238)),
    ABYSSMAL(0.0, new Color(0, 0, 0), new Color(238, 238, 238)),
    NA(0.0, new Color(255, 255, 255), new Color(238, 238, 238));

    private final double floor;
    private final Color fillColor;
    private final Color lineColor;

    private CoverageRange(double floor, Color fillColor, Color lineColor) {
        this.floor = floor;
        this.fillColor = fillColor;
        this.lineColor = lineColor;
    }

    public static final CoverageRange valueOf(Double amount) {
        for (CoverageRange range : CoverageRange.values()) {
            if (!(amount >= range.floor)) continue;
            return range;
        }
        return ABYSSMAL;
    }

    public static final Color fillColorOf(Double amount) {
        try {
            for (int i = 0; i < CoverageRange.values().length; ++i) {
                CoverageRange range = CoverageRange.values()[i];
                if (amount == range.floor) {
                    return range.fillColor;
                }
                if (!(amount > range.floor)) continue;
                CoverageRange range1 = CoverageRange.values()[i - 1];
                double t0 = amount - range.floor;
                double t1 = range1.floor - amount;
                return CoverageRange.blendedColor(range.fillColor, range1.fillColor, t0, t1);
            }
        }
        catch (RuntimeException e) {
            return CoverageRange.ABYSSMAL.fillColor;
        }
        return CoverageRange.ABYSSMAL.fillColor;
    }

    private static Color blendedColor(Color fillColor0, Color fillColor1, double t0, double t1) {
        double total = t0 + t1;
        int r = (int)(((double)fillColor0.getRed() * t1 + (double)fillColor1.getRed() * t0) / total);
        int g = (int)(((double)fillColor0.getGreen() * t1 + (double)fillColor1.getGreen() * t0) / total);
        int b = (int)(((double)fillColor0.getBlue() * t1 + (double)fillColor1.getBlue() * t0) / total);
        return new Color(r, g, b);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public String getFillHexString() {
        return CoverageRange.colorAsHexString(this.fillColor);
    }

    public String getLineHexString() {
        return CoverageRange.colorAsHexString(this.lineColor);
    }

    public static String colorAsHexString(Color c) {
        return String.format("%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    public double getFloor() {
        return this.floor;
    }
}

