/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.model.BuildListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportFactory {
    private final File workspaceDir;
    private File outputDirectory;
    private String outputEncoding;
    private String sourceEncoding;
    private File dataFile;
    private List<String> includes;
    private List<String> excludes;
    private boolean skip;
    private MavenProject project;
    private SessionInfoStore sessionInfoStore;
    private ExecutionDataStore executionDataStore;
    private BuildListener listener;

    public ReportFactory(File workspaceDir, BuildListener listener) {
        if (workspaceDir == null) {
            throw new NullPointerException("Null workspace not allowed");
        }
        this.workspaceDir = workspaceDir;
        this.listener = listener;
    }

    protected void executeReport(Locale locale) throws IOException {
        PrintStream logger = this.listener.getLogger();
        try {
            logger.println("Executing loadExecutionData..");
            this.loadExecutionData();
        }
        catch (IOException e) {
            logger.println("NO EXEC FILE!");
            throw new RuntimeException("Unable to read execution data file " + this.dataFile + ": " + e.getMessage(), e);
        }
        logger.println("Executing createVisitor()");
        IReportVisitor visitor = this.createVisitor();
        logger.println("Executing visitInfo");
        visitor.visitInfo(this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
        logger.println("Executing createReport(visitor)");
        this.createReport((IReportGroupVisitor)visitor);
        logger.println("Executing visitEnd()..");
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExecutionData() throws IOException {
        PrintStream logger = this.listener.getLogger();
        logger.println("Executing sessionInfoStore..");
        this.sessionInfoStore = new SessionInfoStore();
        logger.println("Executing executionDataStore..");
        this.executionDataStore = new ExecutionDataStore();
        FileInputStream in = null;
        try {
            logger.println("Executing newFileInputStream..");
            in = new FileInputStream(this.dataFile);
            logger.println("Executing ExecutionDataReader..");
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)in);
            reader.setSessionInfoVisitor((ISessionInfoVisitor)this.sessionInfoStore);
            reader.setExecutionDataVisitor((IExecutionDataVisitor)this.executionDataStore);
            reader.read();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void createReport(IReportGroupVisitor visitor) throws IOException {
        IBundleCoverage bundle = this.createBundle();
        SourceFileCollection locator = new SourceFileCollection(this.getCompileSourceRoots(), this.sourceEncoding);
        this.checkForMissingDebugInformation((ICoverageNode)bundle);
        visitor.visitBundle(bundle, (ISourceFileLocator)locator);
    }

    private void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.getClassCounter().getTotalCount() > 0 && node.getLineCounter().getTotalCount() == 0) {
            System.out.println("To enable source code annotation class files have to be compiled with debug information.");
        }
    }

    private IBundleCoverage createBundle() throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, (ICoverageVisitor)builder);
        File classesDir = new File(this.workspaceDir, "\\target\\classes");
        List<File> filesToAnalyze = this.getFilesToAnalyze(classesDir);
        for (File file : filesToAnalyze) {
            analyzer.analyzeAll(file);
        }
        return builder.getBundle("projectName");
    }

    private IReportVisitor createVisitor() throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        this.outputDirectory.mkdirs();
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(xmlFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jacoco.xml"))));
        CSVFormatter formatter = new CSVFormatter();
        formatter.setOutputEncoding(this.outputEncoding);
        visitors.add(formatter.createVisitor((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jacoco.csv"))));
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.outputDirectory)));
        return new MultiReportVisitor(visitors);
    }

    private List<File> getCompileSourceRoots() {
        ArrayList<File> result = new ArrayList<File>();
        result.add(new File(this.workspaceDir, "\\src\\main\\java"));
        result.add(new File(this.workspaceDir, "\\src\\test\\java"));
        return result;
    }

    protected List<File> getFilesToAnalyze(File rootDir) throws IOException {
        return Collections.singletonList(rootDir);
    }

    public void createReport() throws IOException {
        PrintStream logger = this.listener.getLogger();
        this.dataFile = new File(this.workspaceDir, "\\target\\jacoco.exec").getAbsoluteFile();
        logger.println("Execfile should be here: " + this.workspaceDir + "\\target\\jacoco.exec");
        this.outputDirectory = new File(this.workspaceDir, "\\target\\jenkins-jacoco").getAbsoluteFile();
        this.outputEncoding = "UTF-8";
        this.sourceEncoding = "UTF-8";
        logger.println("Executin executeReport..");
        this.executeReport(Locale.ENGLISH);
    }

    public static void main(String[] args) throws IOException {
        ReportFactory rf = new ReportFactory(new File("."), null);
        rf.dataFile = new File("target/jacoco.exec");
        rf.outputDirectory = new File("target/jenkins-jacoco");
        rf.outputEncoding = "UTF-8";
        rf.sourceEncoding = "UTF-8";
        rf.executeReport(Locale.ENGLISH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final List<File> sourceRoots;
        private final String encoding;

        public SourceFileCollection(List<File> sourceRoots, String encoding) {
            if (sourceRoots == null) {
                throw new NullPointerException();
            }
            if (encoding == null) {
                throw new NullPointerException();
            }
            this.sourceRoots = sourceRoots;
            this.encoding = encoding;
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            String r = packageName.length() > 0 ? packageName + '/' + fileName : fileName;
            for (File sourceRoot : this.sourceRoots) {
                File file = new File(sourceRoot, r);
                if (!file.exists() || !file.isFile()) continue;
                return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            }
            return null;
        }

        public int getTabWidth() {
            return 4;
        }
    }
}

