/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.model.CoverageObject;
import hudson.plugins.jacoco.report.AggregatedReport;
import hudson.plugins.jacoco.report.ClassReport;
import hudson.plugins.jacoco.report.SourceFileReport;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.jacoco.core.analysis.IMethodCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodReport
extends AggregatedReport<ClassReport, MethodReport, SourceFileReport> {
    public String desc;
    public String lineNo;
    public String sourceFilePath;
    ArrayList<String> sourceLines;
    private IMethodCoverage methodCov;
    private static final Logger logger = Logger.getLogger(CoverageObject.class.getName());

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc(String desc) {
        return this.desc;
    }

    @Override
    public String getDisplayName() {
        return super.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(String filePath) throws FileNotFoundException, IOException {
        ArrayList<String> aList = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            String line = null;
            while ((line = br.readLine()) != null) {
                aList.add(line.replaceAll("\\t", "&nbsp&nbsp&nbsp&nbsp").replaceAll("<", "&lt").replaceAll(">", "&gt"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.sourceLines = aList;
    }

    @Override
    public String printFourCoverageColumns() {
        StringBuilder buf = new StringBuilder();
        this.instruction.setType(CoverageElement.Type.INSTRUCTION);
        this.complexity.setType(CoverageElement.Type.COMPLEXITY);
        this.branch.setType(CoverageElement.Type.BRANCH);
        this.line.setType(CoverageElement.Type.LINE);
        this.method.setType(CoverageElement.Type.METHOD);
        this.printRatioCell(this.isFailed(), this.instruction, buf);
        this.printRatioCell(this.isFailed(), this.branch, buf);
        this.printRatioCell(this.isFailed(), this.complexity, buf);
        this.printRatioCell(this.isFailed(), this.line, buf);
        this.printRatioCell(this.isFailed(), this.method, buf);
        return buf.toString();
    }

    @Override
    public void add(SourceFileReport child) {
        String newChildName = child.getName().replaceAll(this.getName() + ".", "");
        child.setName(newChildName);
        this.getChildren().put(child.getName(), child);
        this.hasClassCoverage();
    }

    public void setSrcFileInfo(IMethodCoverage methodCov, String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
        this.methodCov = methodCov;
    }

    public String printHighlightedSrcFile() {
        StringBuilder buf = new StringBuilder();
        try {
            this.readFile(this.sourceFilePath);
            buf.append("<code style=\"white-space:pre;\">");
            for (int i = 1; i <= this.sourceLines.size(); ++i) {
                if (this.methodCov.getLine(i).getInstructionCounter().getStatus() == 2 || this.methodCov.getLine(i).getInstructionCounter().getStatus() == 3) {
                    buf.append(i + ": ").append("<SPAN style=\"BACKGROUND-COLOR: #32cd32\">" + this.sourceLines.get(i - 1)).append("</SPAN>").append("<br>");
                    continue;
                }
                buf.append(i + ": ").append(this.sourceLines.get(i - 1)).append("<br>");
            }
        }
        catch (FileNotFoundException e) {
            buf.append("ERROR: Sourcefile does not exist!");
        }
        catch (IOException e) {
            buf.append("ERROR: Error while reading the sourcefile!");
        }
        return buf.toString();
    }
}

