/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.report;

import hudson.plugins.jacoco.report.AbstractReport;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregatedReport<PARENT extends AggregatedReport<?, PARENT, ?>, SELF extends AggregatedReport<PARENT, SELF, CHILD>, CHILD extends AbstractReport<SELF, CHILD>>
extends AbstractReport<PARENT, SELF> {
    private final Map<String, CHILD> children = new TreeMap<String, CHILD>();

    public void add(CHILD child) {
        this.children.put(((AbstractReport)child).getName(), child);
        this.hasClassCoverage();
    }

    public Map<String, CHILD> getChildren() {
        return this.children;
    }

    @Override
    protected void setParent(PARENT p) {
        super.setParent(p);
        for (AbstractReport c : this.children.values()) {
            c.setParent(this);
        }
    }

    public CHILD getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return (CHILD)((AbstractReport)this.getChildren().get(token));
    }

    @Override
    public void setFailed() {
        super.setFailed();
        if (this.getParent() != null) {
            ((AggregatedReport)this.getParent()).setFailed();
        }
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public boolean hasChildrenLineCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasLineCoverage()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildrenClassCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasClassCoverage()) continue;
            return true;
        }
        return false;
    }
}

