/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.portlet;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.portlet.bean.JacocoCoverageResultSummary;
import hudson.plugins.jacoco.portlet.utils.Utils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JacocoLoadData {
    private JacocoLoadData() {
    }

    public static Map<LocalDate, JacocoCoverageResultSummary> loadChartDataWithinRange(List<Job> jobs, int daysNumber) {
        HashMap<LocalDate, JacocoCoverageResultSummary> summaries = new HashMap<LocalDate, JacocoCoverageResultSummary>();
        LocalDate lastDate = Utils.getLastDate(jobs);
        if (lastDate == null) {
            return null;
        }
        LocalDate firstDate = lastDate.minusDays(daysNumber);
        block0: for (Job job : jobs) {
            Run run = job.getLastBuild();
            if (null == run) continue;
            LocalDate runDate = new LocalDate((Object)run.getTimestamp());
            while (runDate.isAfter((ReadablePartial)firstDate)) {
                JacocoLoadData.summarize(summaries, run, runDate, job);
                run = run.getPreviousBuild();
                if (null == run) continue block0;
                runDate = new LocalDate((Object)run.getTimestamp());
            }
        }
        TreeMap<LocalDate, JacocoCoverageResultSummary> sortedSummaries = new TreeMap<LocalDate, JacocoCoverageResultSummary>(summaries);
        return sortedSummaries;
    }

    private static void summarize(Map<LocalDate, JacocoCoverageResultSummary> summaries, Run run, LocalDate runDate, Job job) {
        JacocoCoverageResultSummary jacocoCoverageResult = JacocoLoadData.getResult(run);
        JacocoCoverageResultSummary jacocoCoverageResultSummary = summaries.get(runDate);
        if (jacocoCoverageResultSummary == null) {
            jacocoCoverageResultSummary = new JacocoCoverageResultSummary();
            jacocoCoverageResultSummary.addCoverageResult(jacocoCoverageResult);
            jacocoCoverageResultSummary.setJob(job);
        } else {
            List<JacocoCoverageResultSummary> listResults = jacocoCoverageResultSummary.getJacocoCoverageResults();
            boolean found = false;
            for (JacocoCoverageResultSummary item : listResults) {
                if (null == item.getJob() || null == item.getJob().getName() || null == job || !item.getJob().getName().equals(job.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                jacocoCoverageResultSummary.addCoverageResult(jacocoCoverageResult);
                jacocoCoverageResultSummary.setJob(job);
            }
        }
        summaries.put(runDate, jacocoCoverageResultSummary);
    }

    private static JacocoCoverageResultSummary getResult(Run run) {
        JacocoBuildAction jacocoAction = (JacocoBuildAction)run.getAction(JacocoBuildAction.class);
        float classCoverage = 0.0f;
        float lineCoverage = 0.0f;
        float methodCoverage = 0.0f;
        float branchCoverage = 0.0f;
        float instructionCoverage = 0.0f;
        float complexityScore = 0.0f;
        if (jacocoAction != null) {
            if (null != jacocoAction.getClassCoverage()) {
                classCoverage = jacocoAction.getClassCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getLineCoverage()) {
                lineCoverage = jacocoAction.getLineCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getMethodCoverage()) {
                methodCoverage = jacocoAction.getMethodCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getBranchCoverage()) {
                branchCoverage = jacocoAction.getBranchCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getInstructionCoverage()) {
                instructionCoverage = jacocoAction.getInstructionCoverage().getPercentageFloat();
            }
            if (null != jacocoAction.getComplexityScore()) {
                complexityScore = jacocoAction.getComplexityScore().getPercentageFloat();
            }
        }
        return new JacocoCoverageResultSummary(run.getParent(), lineCoverage, methodCoverage, classCoverage, branchCoverage, instructionCoverage, complexityScore);
    }

    public static JacocoCoverageResultSummary getResultSummary(Collection<Job> jobs) {
        JacocoCoverageResultSummary summary = new JacocoCoverageResultSummary();
        for (Job job : jobs) {
            JacocoBuildAction jacocoAction;
            float classCoverage = 0.0f;
            float lineCoverage = 0.0f;
            float methodCoverage = 0.0f;
            float branchCoverage = 0.0f;
            float instructionCoverage = 0.0f;
            float complexityScore = 0.0f;
            Run run = job.getLastSuccessfulBuild();
            if (run != null && null != (jacocoAction = (JacocoBuildAction)job.getLastSuccessfulBuild().getAction(JacocoBuildAction.class))) {
                if (null != jacocoAction.getClassCoverage()) {
                    classCoverage = jacocoAction.getClassCoverage().getPercentageFloat();
                    BigDecimal bigClassCoverage = new BigDecimal(classCoverage);
                    bigClassCoverage = bigClassCoverage.setScale(1, 6);
                    classCoverage = bigClassCoverage.floatValue();
                }
                if (null != jacocoAction.getLineCoverage()) {
                    lineCoverage = jacocoAction.getLineCoverage().getPercentageFloat();
                    BigDecimal bigLineCoverage = new BigDecimal(lineCoverage);
                    bigLineCoverage = bigLineCoverage.setScale(1, 6);
                    lineCoverage = bigLineCoverage.floatValue();
                }
                if (null != jacocoAction.getMethodCoverage()) {
                    methodCoverage = jacocoAction.getMethodCoverage().getPercentageFloat();
                    BigDecimal bigMethodCoverage = new BigDecimal(methodCoverage);
                    bigMethodCoverage = bigMethodCoverage.setScale(1, 6);
                    methodCoverage = bigMethodCoverage.floatValue();
                }
                if (null != jacocoAction.getBranchCoverage()) {
                    branchCoverage = jacocoAction.getBranchCoverage().getPercentageFloat();
                    BigDecimal bigBranchCoverage = new BigDecimal(branchCoverage);
                    bigBranchCoverage = bigBranchCoverage.setScale(1, 6);
                    branchCoverage = bigBranchCoverage.floatValue();
                }
                if (null != jacocoAction.getInstructionCoverage()) {
                    instructionCoverage = jacocoAction.getInstructionCoverage().getPercentageFloat();
                    BigDecimal bigInstructionCoverage = new BigDecimal(instructionCoverage);
                    bigInstructionCoverage = bigInstructionCoverage.setScale(1, 6);
                    instructionCoverage = bigInstructionCoverage.floatValue();
                }
                if (null != jacocoAction.getComplexityScore()) {
                    complexityScore = jacocoAction.getComplexityScore().getPercentageFloat();
                    BigDecimal bigComplexityCoverage = new BigDecimal(complexityScore);
                    bigComplexityCoverage = bigComplexityCoverage.setScale(1, 6);
                    complexityScore = bigComplexityCoverage.floatValue();
                }
            }
            summary.addCoverageResult(new JacocoCoverageResultSummary(job, lineCoverage, methodCoverage, classCoverage, branchCoverage, instructionCoverage, complexityScore));
        }
        return summary;
    }
}

