/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco.model;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Api;
import hudson.plugins.jacoco.Messages;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.report.AggregatedReport;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Logger;
import org.jacoco.core.analysis.ICoverageNode;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public abstract class CoverageObject<SELF extends CoverageObject<SELF>> {
    public Coverage clazz = new Coverage();
    public Coverage method = new Coverage();
    public Coverage line = new Coverage();
    public Coverage complexity = new Coverage();
    public Coverage instruction = new Coverage();
    public Coverage branch = new Coverage();
    public int maxCoveredClazz = 1;
    public int maxCoveredMethod = 1;
    public int maxCoveredLine = 1;
    public int maxCoveredComplexity = 1;
    public int maxCoveredInstruction = 1;
    public int maxCoveredBranch = 1;
    public int maxMissedClazz = 1;
    public int maxMissedMethod = 1;
    public int maxMissedLine = 1;
    public int maxMissedComplexity = 1;
    public int maxMissedInstruction = 1;
    public int maxMissedBranch = 1;
    @Deprecated
    public transient int maxClazz = 1;
    @Deprecated
    public transient int maxMethod = 1;
    @Deprecated
    public transient int maxLine = 1;
    @Deprecated
    public transient int maxComplexity = 1;
    @Deprecated
    public transient int maxInstruction = 1;
    @Deprecated
    public transient int maxBranch = 1;
    private volatile boolean failed = false;
    static NumberFormat dataFormat = new DecimalFormat("000.00", new DecimalFormatSymbols(Locale.US));
    static NumberFormat percentFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
    static NumberFormat intFormat = new DecimalFormat("0", new DecimalFormatSymbols(Locale.US));
    private static final Logger logger = Logger.getLogger(CoverageObject.class.getName());

    public int getMaxCoveredClazz() {
        return this.maxCoveredClazz;
    }

    public void setMaxCoveredClazz(int maxClazz) {
        this.maxCoveredClazz = maxClazz;
    }

    public int getMaxCoveredMethod() {
        return this.maxCoveredMethod;
    }

    public void setMaxCoveredMethod(int maxMethod) {
        this.maxCoveredMethod = maxMethod;
    }

    public int getMaxCoveredLine() {
        return this.maxCoveredLine;
    }

    public void setMaxCoveredLine(int maxLine) {
        this.maxCoveredLine = maxLine;
    }

    public int getMaxCoveredComplexity() {
        return this.maxCoveredComplexity;
    }

    public void setMaxCoveredComplexity(int maxComplexity) {
        this.maxCoveredComplexity = maxComplexity;
    }

    public int getMaxCoveredInstruction() {
        return this.maxCoveredInstruction;
    }

    public void setMaxCoveredInstruction(int maxInstruction) {
        this.maxCoveredInstruction = maxInstruction;
    }

    public int getMaxCoveredBranch() {
        return this.maxCoveredBranch;
    }

    public void setMaxCoveredBranch(int maxBranch) {
        this.maxCoveredBranch = maxBranch;
    }

    public int getMaxMissedClazz() {
        return this.maxMissedClazz;
    }

    public void setMaxMissedClazz(int maxMissedClazz) {
        this.maxMissedClazz = maxMissedClazz;
    }

    public int getMaxMissedMethod() {
        return this.maxMissedMethod;
    }

    public void setMaxMissedMethod(int maxMissedMethod) {
        this.maxMissedMethod = maxMissedMethod;
    }

    public int getMaxMissedLine() {
        return this.maxMissedLine;
    }

    public void setMaxMissedLine(int maxMissedLine) {
        this.maxMissedLine = maxMissedLine;
    }

    public int getMaxMissedComplexity() {
        return this.maxMissedComplexity;
    }

    public void setMaxMissedComplexity(int maxMissedComplexity) {
        this.maxMissedComplexity = maxMissedComplexity;
    }

    public int getMaxMissedInstruction() {
        return this.maxMissedInstruction;
    }

    public void setMaxMissedInstruction(int maxMissedInstruction) {
        this.maxMissedInstruction = maxMissedInstruction;
    }

    public int getMaxMissedBranch() {
        return this.maxMissedBranch;
    }

    public void setMaxMissedBranch(int maxMissedBranch) {
        this.maxMissedBranch = maxMissedBranch;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = true;
    }

    @Exported(inline=true)
    public Coverage getClassCoverage() {
        return this.clazz;
    }

    @Exported(inline=true)
    public Coverage getMethodCoverage() {
        return this.method;
    }

    @Exported(inline=true)
    public Coverage getComplexityScore() {
        return this.complexity;
    }

    @Exported(inline=true)
    public Coverage getInstructionCoverage() {
        return this.instruction;
    }

    @Exported(inline=true)
    public Coverage getBranchCoverage() {
        return this.branch;
    }

    @Exported(inline=true)
    public Coverage getLineCoverage() {
        return this.line;
    }

    public abstract AbstractBuild<?, ?> getBuild();

    @Exported
    public abstract SELF getPreviousResult();

    public CoverageObject getParent() {
        return null;
    }

    public String printFourCoverageColumns() {
        StringBuilder buf = new StringBuilder();
        this.instruction.setType(CoverageElement.Type.INSTRUCTION);
        this.clazz.setType(CoverageElement.Type.CLASS);
        this.complexity.setType(CoverageElement.Type.COMPLEXITY);
        this.branch.setType(CoverageElement.Type.BRANCH);
        this.line.setType(CoverageElement.Type.LINE);
        this.method.setType(CoverageElement.Type.METHOD);
        this.printRatioCell(this.isFailed(), this.instruction, buf);
        this.printRatioCell(this.isFailed(), this.branch, buf);
        this.printRatioCell(this.isFailed(), this.complexity, buf);
        this.printRatioCell(this.isFailed(), this.line, buf);
        this.printRatioCell(this.isFailed(), this.method, buf);
        this.printRatioCell(this.isFailed(), this.clazz, buf);
        return buf.toString();
    }

    public boolean hasLineCoverage() {
        return this.line.isInitialized();
    }

    public boolean hasClassCoverage() {
        return this.clazz.isInitialized();
    }

    protected void printRatioCell(boolean failed, Coverage ratio, StringBuilder buf) {
        if (ratio != null && ratio.isInitialized()) {
            buf.append("<td class='").append("").append("'");
            buf.append(" data='").append(dataFormat.format(ratio.getPercentageFloat()));
            buf.append("'>\n");
            this.printRatioTable(ratio, buf);
            buf.append("</td>\n");
        }
    }

    protected void printRatioTable(Coverage ratio, StringBuilder buf) {
        String percent = percentFormat.format(ratio.getPercentageFloat());
        String numerator = intFormat.format(ratio.getMissed());
        String denominator = intFormat.format(ratio.getCovered());
        int maximumCovered = 2;
        int maximumMissed = 2;
        if (ratio.getType().equals((Object)CoverageElement.Type.INSTRUCTION)) {
            maximumCovered = this.getParent().maxCoveredInstruction;
            maximumMissed = this.getParent().maxMissedInstruction;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.BRANCH)) {
            maximumCovered = this.getParent().maxCoveredBranch;
            maximumMissed = this.getParent().maxMissedBranch;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.COMPLEXITY)) {
            maximumCovered = this.getParent().maxCoveredComplexity;
            maximumMissed = this.getParent().maxMissedComplexity;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.LINE)) {
            maximumCovered = this.getParent().maxCoveredLine;
            maximumMissed = this.getParent().maxMissedLine;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.METHOD)) {
            maximumCovered = this.getParent().maxCoveredMethod;
            maximumMissed = this.getParent().maxMissedMethod;
        } else if (ratio.getType().equals((Object)CoverageElement.Type.CLASS)) {
            maximumCovered = this.getParent().maxCoveredClazz;
            maximumMissed = this.getParent().maxMissedClazz;
        }
        buf.append("<table class='percentgraph' cellpadding='0px' cellspacing='0px'>").append("<tr><td class='percentgraph'>").append("<span class='text'>").append("<b>M:</b> " + numerator).append(" ").append("<b>C:</b> " + denominator).append("</span></td></tr>").append("<tr>").append("<td width='40px' class='data'>").append(ratio.getPercentage()).append("%</td>").append("<td>").append("<div class='percentgraph' style='width: ").append((float)ratio.getCovered() / (float)maximumCovered * 100.0f).append("px;'>").append("<div class='redbar' style='width: ").append(ratio.getMissed() > ratio.getCovered() ? (float)ratio.getMissed() / (float)maximumMissed * 100.0f : (float)ratio.getMissed() / (float)maximumCovered * 100.0f).append("px;'>").append("</td></tr>").append("</table>");
    }

    protected <ReportLevel extends AggregatedReport> void setAllCovTypes(ReportLevel reportToSet, ICoverageNode covReport) {
        Coverage tempCov = new Coverage();
        tempCov.accumulate(covReport.getClassCounter().getMissedCount(), covReport.getClassCounter().getCoveredCount());
        reportToSet.clazz = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getBranchCounter().getMissedCount(), covReport.getBranchCounter().getCoveredCount());
        reportToSet.branch = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getLineCounter().getMissedCount(), covReport.getLineCounter().getCoveredCount());
        reportToSet.line = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getInstructionCounter().getMissedCount(), covReport.getInstructionCounter().getCoveredCount());
        reportToSet.instruction = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getMethodCounter().getMissedCount(), covReport.getMethodCounter().getCoveredCount());
        reportToSet.method = tempCov;
        tempCov = new Coverage();
        tempCov.accumulate(covReport.getComplexityCounter().getMissedCount(), covReport.getComplexityCounter().getCoveredCount());
        reportToSet.complexity = tempCov;
    }

    public <ReportLevel extends AggregatedReport> void setCoverage(ReportLevel reportToSet, ICoverageNode covReport) {
        this.setAllCovTypes(reportToSet, covReport);
        if (this.maxCoveredClazz < reportToSet.clazz.getCovered()) {
            this.maxCoveredClazz = reportToSet.clazz.getCovered();
        }
        if (this.maxMissedClazz < reportToSet.clazz.getMissed()) {
            this.maxMissedClazz = reportToSet.clazz.getMissed();
        }
        if (this.maxCoveredBranch < reportToSet.branch.getCovered()) {
            this.maxCoveredBranch = reportToSet.branch.getCovered();
        }
        if (this.maxMissedBranch < reportToSet.branch.getMissed()) {
            this.maxMissedBranch = reportToSet.branch.getMissed();
        }
        if (this.maxCoveredLine < reportToSet.line.getCovered()) {
            this.maxCoveredLine = reportToSet.line.getCovered();
        }
        if (this.maxMissedLine < reportToSet.line.getMissed()) {
            this.maxMissedLine = reportToSet.line.getMissed();
        }
        if (this.maxCoveredInstruction < reportToSet.instruction.getCovered()) {
            this.maxCoveredInstruction = reportToSet.instruction.getCovered();
        }
        if (this.maxMissedInstruction < reportToSet.instruction.getMissed()) {
            this.maxMissedInstruction = reportToSet.instruction.getMissed();
        }
        if (this.maxCoveredMethod < reportToSet.method.getCovered()) {
            this.maxCoveredMethod = reportToSet.method.getCovered();
        }
        if (this.maxMissedMethod < reportToSet.method.getMissed()) {
            this.maxMissedMethod = reportToSet.method.getMissed();
        }
        if (this.maxCoveredComplexity < reportToSet.complexity.getCovered()) {
            this.maxCoveredComplexity = reportToSet.complexity.getCovered();
        }
        if (this.maxMissedComplexity < reportToSet.complexity.getMissed()) {
            this.maxMissedComplexity = reportToSet.complexity.getMissed();
        }
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        AbstractBuild<?, ?> build = this.getBuild();
        Calendar t = build.getTimestamp();
        String w = Util.fixEmptyAndTrim((String)req.getParameter("width"));
        String h = Util.fixEmptyAndTrim((String)req.getParameter("height"));
        int width = w != null ? Integer.valueOf(w) : 500;
        int height = h != null ? Integer.valueOf(h) : 200;
        new GraphImpl(this, t, width, height){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet(CoverageObject<SELF> obj) {
                DataSetBuilder dsb = new DataSetBuilder();
                for (CoverageObject a = obj; a != null; a = a.getPreviousResult()) {
                    ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getBuild());
                    if (a.line != null) {
                        dsb.add((Number)a.line.getCovered(), (Comparable)((Object)Messages.CoverageObject_Legend_LineCovered()), (Comparable)label);
                        dsb.add((Number)a.line.getMissed(), (Comparable)((Object)Messages.CoverageObject_Legend_LineMissed()), (Comparable)label);
                        continue;
                    }
                    dsb.add((Number)0, (Comparable)((Object)Messages.CoverageObject_Legend_LineCovered()), (Comparable)label);
                    dsb.add((Number)0, (Comparable)((Object)Messages.CoverageObject_Legend_LineMissed()), (Comparable)label);
                }
                return dsb;
            }
        }.doPng(req, rsp);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + " instruction=" + this.instruction + " branch=" + this.branch + " complexity=" + this.complexity + " line=" + this.line + " method=" + this.method + " class=" + this.clazz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class GraphImpl
    extends Graph {
        private CoverageObject<SELF> obj;

        public GraphImpl(CoverageObject<SELF> obj, Calendar timestamp, int defaultW, int defaultH) {
            super(timestamp, defaultW, defaultH);
            this.obj = obj;
        }

        protected abstract DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet(CoverageObject<SELF> var1);

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.createDataSet(this.obj).build();
            JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            LegendTitle legend = chart.getLegend();
            legend.setPosition(RectangleEdge.RIGHT);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            if (CoverageObject.this.line != null) {
                rangeAxis.setUpperBound(CoverageObject.this.line.getCovered() > CoverageObject.this.line.getMissed() ? (double)(CoverageObject.this.line.getCovered() + 5) : (double)(CoverageObject.this.line.getMissed() + 5));
            }
            rangeAxis.setLowerBound(0.0);
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
            renderer.setSeriesPaint(0, (Paint)Color.green);
            renderer.setSeriesPaint(1, (Paint)Color.red);
            renderer.setSeriesItemLabelPaint(0, (Paint)Color.green);
            renderer.setSeriesItemLabelPaint(1, (Paint)Color.red);
            renderer.setSeriesFillPaint(0, (Paint)Color.green);
            renderer.setSeriesFillPaint(1, (Paint)Color.red);
            renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
            plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
            return chart;
        }
    }
}

