/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.JacocoHealthReportThresholds;
import hudson.plugins.jacoco.JacocoProjectAction;
import hudson.plugins.jacoco.Messages;
import hudson.plugins.jacoco.Rule;
import hudson.plugins.jacoco.report.CoverageReport;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacocoPublisher
extends Recorder {
    public Rule rule;
    @Deprecated
    public transient String includes;
    @Deprecated
    public transient int moduleNum;
    public JacocoHealthReportThresholds healthReports;
    private final String execPattern;
    private final String classPattern;
    private final String sourcePattern;
    private final String inclusionPattern;
    private final String exclusionPattern;
    private final String minimumInstructionCoverage;
    private final String minimumBranchCoverage;
    private final String minimumComplexityCoverage;
    private final String minimumLineCoverage;
    private final String minimumMethodCoverage;
    private final String minimumClassCoverage;
    private final String maximumInstructionCoverage;
    private final String maximumBranchCoverage;
    private final String maximumComplexityCoverage;
    private final String maximumLineCoverage;
    private final String maximumMethodCoverage;
    private final String maximumClassCoverage;
    @Extension
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DescriptorImpl();
    private static final Logger logger = Logger.getLogger(JacocoPublisher.class.getName());

    @DataBoundConstructor
    public JacocoPublisher(String execPattern, String classPattern, String sourcePattern, String inclusionPattern, String exclusionPattern, String maximumInstructionCoverage, String maximumBranchCoverage, String maximumComplexityCoverage, String maximumLineCoverage, String maximumMethodCoverage, String maximumClassCoverage, String minimumInstructionCoverage, String minimumBranchCoverage, String minimumComplexityCoverage, String minimumLineCoverage, String minimumMethodCoverage, String minimumClassCoverage) {
        this.execPattern = execPattern;
        this.classPattern = classPattern;
        this.sourcePattern = sourcePattern;
        this.inclusionPattern = inclusionPattern;
        this.exclusionPattern = exclusionPattern;
        this.minimumInstructionCoverage = minimumInstructionCoverage;
        this.minimumBranchCoverage = minimumBranchCoverage;
        this.minimumComplexityCoverage = minimumComplexityCoverage;
        this.minimumLineCoverage = minimumLineCoverage;
        this.minimumMethodCoverage = minimumMethodCoverage;
        this.minimumClassCoverage = minimumClassCoverage;
        this.maximumInstructionCoverage = maximumInstructionCoverage;
        this.maximumBranchCoverage = maximumBranchCoverage;
        this.maximumComplexityCoverage = maximumComplexityCoverage;
        this.maximumLineCoverage = maximumLineCoverage;
        this.maximumMethodCoverage = maximumMethodCoverage;
        this.maximumClassCoverage = maximumClassCoverage;
    }

    public String toString() {
        return "JacocoPublisher [execPattern=" + this.execPattern + ", classPattern=" + this.classPattern + ", sourcePattern=" + this.sourcePattern + ", inclusionPattern=" + this.inclusionPattern + ", exclusionPattern=" + this.exclusionPattern + ", minimumInstructionCoverage=" + this.minimumInstructionCoverage + ", minimumBranchCoverage=" + this.minimumBranchCoverage + ", minimumComplexityCoverage=" + this.minimumComplexityCoverage + ", minimumLineCoverage=" + this.minimumLineCoverage + ", minimumMethodCoverage=" + this.minimumMethodCoverage + ", minimumClassCoverage=" + this.minimumClassCoverage + ", maximumInstructionCoverage=" + this.maximumInstructionCoverage + ", maximumBranchCoverage=" + this.maximumBranchCoverage + ", maximumComplexityCoverage=" + this.maximumComplexityCoverage + ", maximumLineCoverage=" + this.maximumLineCoverage + ", maximumMethodCoverage=" + this.maximumMethodCoverage + ", maximumClassCoverage=" + this.maximumClassCoverage + "]";
    }

    public String getExecPattern() {
        return this.execPattern;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getSourcePattern() {
        return this.sourcePattern;
    }

    public String getInclusionPattern() {
        return this.inclusionPattern;
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    public String getMinimumInstructionCoverage() {
        return this.minimumInstructionCoverage;
    }

    public String getMinimumBranchCoverage() {
        return this.minimumBranchCoverage;
    }

    public String getMinimumComplexityCoverage() {
        return this.minimumComplexityCoverage;
    }

    public String getMinimumLineCoverage() {
        return this.minimumLineCoverage;
    }

    public String getMinimumMethodCoverage() {
        return this.minimumMethodCoverage;
    }

    public String getMinimumClassCoverage() {
        return this.minimumClassCoverage;
    }

    public String getMaximumInstructionCoverage() {
        return this.maximumInstructionCoverage;
    }

    public String getMaximumBranchCoverage() {
        return this.maximumBranchCoverage;
    }

    public String getMaximumComplexityCoverage() {
        return this.maximumComplexityCoverage;
    }

    public String getMaximumLineCoverage() {
        return this.maximumLineCoverage;
    }

    public String getMaximumMethodCoverage() {
        return this.maximumMethodCoverage;
    }

    public String getMaximumClassCoverage() {
        return this.maximumClassCoverage;
    }

    protected static void saveCoverageReports(FilePath destFolder, FilePath sourceFolder) throws IOException, InterruptedException {
        destFolder.mkdirs();
        sourceFolder.copyRecursiveTo(destFolder);
    }

    protected static String resolveFilePaths(AbstractBuild<?, ?> build, BuildListener listener, String input) {
        try {
            return build.getEnvironment((TaskListener)listener).expand(input);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to resolve parameters in string \"" + input + "\" due to following error:\n" + e.getMessage());
            return input;
        }
    }

    protected static FilePath[] resolveDirPaths(AbstractBuild<?, ?> build, BuildListener listener, final String input) {
        PrintStream logger = listener.getLogger();
        FilePath[] directoryPaths = null;
        try {
            directoryPaths = (FilePath[])build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<FilePath[]>(){

                public FilePath[] invoke(File f, VirtualChannel channel) throws IOException {
                    String[] dirs;
                    ArrayList<FilePath> localDirectoryPaths = new ArrayList<FilePath>();
                    String[] includes = input.split(",");
                    DirectoryScanner ds = new DirectoryScanner();
                    ds.setIncludes(includes);
                    ds.setCaseSensitive(false);
                    ds.setBasedir(f);
                    ds.scan();
                    for (String dir : dirs = ds.getIncludedDirectories()) {
                        localDirectoryPaths.add(new FilePath(new File(dir)));
                    }
                    FilePath[] lfp = new FilePath[]{};
                    return localDirectoryPaths.toArray(lfp);
                }
            });
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return directoryPaths;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        FilePath[] matchedExecFiles = null;
        FilePath[] matchedClassDirs = null;
        FilePath[] matchedSrcDirs = null;
        FilePath actualBuildDirRoot = null;
        FilePath actualBuildClassDir = null;
        FilePath actualBuildSrcDir = null;
        FilePath actualBuildExecDir = null;
        logger.println("[JaCoCo plugin] Collecting JaCoCo coverage data...");
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            this.healthReports = new JacocoHealthReportThresholds(Integer.parseInt(this.minimumClassCoverage), Integer.parseInt(this.maximumClassCoverage), Integer.parseInt(this.minimumMethodCoverage), Integer.parseInt(this.maximumMethodCoverage), Integer.parseInt(this.minimumLineCoverage), Integer.parseInt(this.maximumLineCoverage), Integer.parseInt(this.minimumBranchCoverage), Integer.parseInt(this.maximumBranchCoverage), Integer.parseInt(this.minimumInstructionCoverage), Integer.parseInt(this.maximumInstructionCoverage), Integer.parseInt(this.minimumComplexityCoverage), Integer.parseInt(this.maximumComplexityCoverage));
        }
        catch (NumberFormatException nfe) {
            this.healthReports = new JacocoHealthReportThresholds(0, 80, 0, 80, 0, 80, 0, 80, 0, 80, 0, 80);
        }
        if (this.execPattern == null || this.classPattern == null || this.sourcePattern == null) {
            if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                return true;
            }
            logger.println("[JaCoCo plugin] ERROR: Missing configuration!");
            build.setResult(Result.FAILURE);
            return true;
        }
        logger.println("[JaCoCo plugin] " + this.execPattern + ";" + this.classPattern + ";" + this.sourcePattern + ";" + " locations are configured");
        actualBuildDirRoot = new FilePath(JacocoPublisher.getJacocoReport(build));
        actualBuildClassDir = new FilePath(actualBuildDirRoot, "classes");
        actualBuildSrcDir = new FilePath(actualBuildDirRoot, "sources");
        actualBuildExecDir = new FilePath(actualBuildDirRoot, "execFiles");
        matchedExecFiles = build.getWorkspace().list(JacocoPublisher.resolveFilePaths(build, listener, this.execPattern));
        logger.println("[JaCoCo plugin] Number of found exec files: " + matchedExecFiles.length);
        logger.print("[JaCoCo plugin] Saving matched execfiles: ");
        int i = 0;
        for (FilePath file : matchedExecFiles) {
            FilePath separateExecDir = new FilePath(actualBuildExecDir, "exec" + i);
            FilePath fullExecName = separateExecDir.child("jacoco.exec");
            file.copyTo(fullExecName);
            logger.print(" " + file.getRemote());
            ++i;
        }
        matchedClassDirs = JacocoPublisher.resolveDirPaths(build, listener, this.classPattern);
        logger.print("\n[JaCoCo plugin] Saving matched class directories: ");
        for (FilePath file : matchedClassDirs) {
            file = new FilePath(build.getWorkspace(), file.getRemote() + "\\");
            JacocoPublisher.saveCoverageReports(actualBuildClassDir, file);
            logger.print(" " + file.getRemote());
        }
        matchedSrcDirs = JacocoPublisher.resolveDirPaths(build, listener, this.sourcePattern);
        logger.print("\n[JaCoCo plugin] Saving matched source directories: ");
        for (FilePath file : matchedSrcDirs) {
            file = new FilePath(build.getWorkspace(), file.getRemote());
            JacocoPublisher.saveCoverageReports(actualBuildSrcDir, file);
            logger.print(" " + file.getRemote());
        }
        logger.println("\n[JaCoCo plugin] Loading inclusions files..");
        Object[] includes = new String[]{};
        if (this.inclusionPattern != null) {
            includes = this.inclusionPattern.split(",");
            logger.println("[JaCoCo plugin] inclusions: " + Arrays.toString(includes));
        }
        Object[] excludes = new String[]{};
        if (this.exclusionPattern != null) {
            excludes = this.exclusionPattern.split(",");
            logger.println("[JaCoCo plugin] exclusions: " + Arrays.toString(excludes));
        }
        JacocoBuildAction action = JacocoBuildAction.load(build, this.rule, this.healthReports, listener, actualBuildDirRoot, (String[])includes, (String[])excludes);
        action.getThresholds().ensureValid();
        logger.println("[JaCoCo plugin] Thresholds: " + action.getThresholds());
        build.getActions().add(action);
        logger.println("[JaCoCo plugin] Publishing the results..");
        CoverageReport result = action.getResult();
        if (result == null) {
            logger.println("[JaCoCo plugin] Could not parse coverage results. Setting Build to failure.");
            build.setResult(Result.FAILURE);
        }
        build.setResult(this.checkResult(action));
        return true;
    }

    public Result checkResult(JacocoBuildAction action) {
        if (action.getBranchCoverage().getPercentage() < action.getThresholds().getMinBranch() || action.getInstructionCoverage().getPercentage() < action.getThresholds().getMinInstruction() || action.getClassCoverage().getPercentage() < action.getThresholds().getMinClass() || action.getLineCoverage().getPercentage() < action.getThresholds().getMinLine() || action.getComplexityScore().getPercentage() < action.getThresholds().getMinComplexity() || action.getMethodCoverage().getPercentage() < action.getThresholds().getMinMethod()) {
            return Result.FAILURE;
        }
        if (action.getBranchCoverage().getPercentage() < action.getThresholds().getMaxBranch() || action.getInstructionCoverage().getPercentage() < action.getThresholds().getMaxInstruction() || action.getClassCoverage().getPercentage() < action.getThresholds().getMaxClass() || action.getLineCoverage().getPercentage() < action.getThresholds().getMaxLine() || action.getComplexityScore().getPercentage() < action.getThresholds().getMaxComplexity() || action.getMethodCoverage().getPercentage() < action.getThresholds().getMaxMethod()) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new JacocoProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    static File getJacocoReport(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "jacoco");
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JacocoPublisher.class);
        }

        public String getDisplayName() {
            return Messages.JacocoPublisher_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }
    }
}

