/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.plugins.jacoco.ExecutionFileLoader;
import hudson.plugins.jacoco.JacocoHealthReportThresholds;
import hudson.plugins.jacoco.JacocoPublisher;
import hudson.plugins.jacoco.Messages;
import hudson.plugins.jacoco.Rule;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageElement;
import hudson.plugins.jacoco.model.CoverageObject;
import hudson.plugins.jacoco.report.CoverageReport;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JacocoBuildAction
extends CoverageObject<JacocoBuildAction>
implements HealthReportingAction,
StaplerProxy,
Serializable {
    public final AbstractBuild<?, ?> owner;
    @Deprecated
    public transient AbstractBuild<?, ?> build;
    public final PrintStream logger;
    @Deprecated
    private transient ArrayList reports;
    private transient WeakReference<CoverageReport> report;
    private final String[] inclusions;
    private final String[] exclusions;
    private final Rule rule;
    private final JacocoHealthReportThresholds thresholds;
    private static final Logger logGer = Logger.getLogger(JacocoBuildAction.class.getName());

    public JacocoBuildAction(AbstractBuild<?, ?> owner, Rule rule, Map<CoverageElement.Type, Coverage> ratios, JacocoHealthReportThresholds thresholds, BuildListener listener, String[] inclusions, String[] exclusions) {
        this.logger = listener.getLogger();
        if (ratios == null) {
            ratios = Collections.emptyMap();
        }
        this.inclusions = inclusions;
        this.exclusions = exclusions;
        this.owner = owner;
        this.rule = rule;
        this.clazz = this.getOrCreateRatio(ratios, CoverageElement.Type.CLASS);
        this.method = this.getOrCreateRatio(ratios, CoverageElement.Type.METHOD);
        this.line = this.getOrCreateRatio(ratios, CoverageElement.Type.LINE);
        this.thresholds = thresholds;
        this.branch = this.getOrCreateRatio(ratios, CoverageElement.Type.BRANCH);
        this.instruction = this.getOrCreateRatio(ratios, CoverageElement.Type.INSTRUCTION);
        this.complexity = this.getOrCreateRatio(ratios, CoverageElement.Type.COMPLEXITY);
    }

    private Coverage getOrCreateRatio(Map<CoverageElement.Type, Coverage> ratios, CoverageElement.Type type) {
        Coverage r = ratios.get((Object)type);
        if (r == null) {
            r = new Coverage();
        }
        return r;
    }

    public String getDisplayName() {
        return Messages.BuildAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "jacoco";
    }

    public HealthReport getBuildHealth() {
        int percent;
        if (this.thresholds == null) {
            return null;
        }
        this.thresholds.ensureValid();
        int score = 100;
        ArrayList<Localizable> reports = new ArrayList<Localizable>(5);
        if (this.clazz != null && this.thresholds.getMaxClass() > 0) {
            percent = this.clazz.getPercentage();
            if (percent < this.thresholds.getMaxClass()) {
                reports.add(Messages._BuildAction_Classes(this.clazz, percent));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinClass(), percent, this.thresholds.getMaxClass());
        }
        if (this.method != null && this.thresholds.getMaxMethod() > 0) {
            percent = this.method.getPercentage();
            if (percent < this.thresholds.getMaxMethod()) {
                reports.add(Messages._BuildAction_Methods(this.method, percent));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinMethod(), percent, this.thresholds.getMaxMethod());
        }
        if (this.line != null && this.thresholds.getMaxLine() > 0) {
            percent = this.line.getPercentage();
            if (percent < this.thresholds.getMaxLine()) {
                reports.add(Messages._BuildAction_Lines(this.line, percent));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinLine(), percent, this.thresholds.getMaxLine());
        }
        if (this.branch != null && this.thresholds.getMaxBranch() > 0) {
            percent = this.branch.getPercentage();
            if (percent < this.thresholds.getMaxBranch()) {
                reports.add(Messages._BuildAction_Branches(this.branch, percent));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinBranch(), percent, this.thresholds.getMaxBranch());
        }
        if (this.instruction != null && this.thresholds.getMaxInstruction() > 0) {
            percent = this.instruction.getPercentage();
            if (percent < this.thresholds.getMaxInstruction()) {
                reports.add(Messages._BuildAction_Instructions(this.instruction, percent));
            }
            score = JacocoBuildAction.updateHealthScore(score, this.thresholds.getMinInstruction(), percent, this.thresholds.getMaxInstruction());
        }
        if (score == 100) {
            reports.add(Messages._BuildAction_Perfect());
        }
        Object[] args = reports.toArray(new Object[5]);
        for (int i = 4; i >= 0 && args[i] == null; --i) {
            args[i] = "";
        }
        return new HealthReport(score, Messages._BuildAction_Description(args[0], args[1], args[2], args[3], args[4]));
    }

    public JacocoHealthReportThresholds getThresholds() {
        return this.thresholds;
    }

    private static int updateHealthScore(int score, int min, int value, int max) {
        if (value >= max) {
            return score;
        }
        if (value <= min) {
            return 0;
        }
        assert (max != min);
        int scaled = (int)(100.0 * (double)((float)value - (float)min) / (double)(max - min));
        if (scaled < score) {
            return scaled;
        }
        return score;
    }

    public Object getTarget() {
        return this.getResult();
    }

    @Override
    public AbstractBuild<?, ?> getBuild() {
        return this.owner;
    }

    protected ExecutionFileLoader getJacocoReports(File file, String[] includes, String[] excludes) throws IOException {
        ExecutionFileLoader efl = null;
        try {
            FilePath path = new FilePath(file);
            FilePath pathToExecFiles = new FilePath(path, "execFiles");
            efl = new ExecutionFileLoader();
            int i = 0;
            FilePath checkPath = null;
            while ((checkPath = new FilePath(pathToExecFiles, "exec" + i)).exists()) {
                efl.addExecFile(new FilePath(checkPath, "jacoco.exec"));
                ++i;
            }
            efl.setIncludes(includes);
            efl.setExcludes(excludes);
            efl.setClassDir(new FilePath(path, "classes"));
            efl.setSrcDir(new FilePath(path, "sources"));
            efl.loadBundleCoverage();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return efl;
    }

    protected static ExecutionFileLoader getJacocoReports(FilePath fp, String[] includes, String[] excludes) throws IOException {
        ExecutionFileLoader efl = null;
        try {
            FilePath path = fp;
            FilePath pathToExecFiles = new FilePath(path, "execFiles");
            efl = new ExecutionFileLoader();
            int i = 0;
            FilePath checkPath = null;
            while ((checkPath = new FilePath(pathToExecFiles, "exec" + i)).exists()) {
                efl.addExecFile(new FilePath(checkPath, "jacoco.exec"));
                ++i;
            }
            efl.setIncludes(includes);
            efl.setExcludes(excludes);
            efl.setClassDir(new FilePath(path, "classes"));
            efl.setSrcDir(new FilePath(path, "sources"));
            efl.loadBundleCoverage();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return efl;
    }

    public synchronized CoverageReport getResult() {
        CoverageReport r;
        if (this.report != null && (r = (CoverageReport)this.report.get()) != null) {
            return r;
        }
        File reportFolder = JacocoPublisher.getJacocoReport(this.owner);
        try {
            CoverageReport r2 = new CoverageReport(this, this.getJacocoReports(reportFolder, this.inclusions, this.exclusions));
            this.report = new WeakReference<CoverageReport>(r2);
            return r2;
        }
        catch (IOException e) {
            this.logger.println("Failed to load " + reportFolder);
            e.printStackTrace(this.logger);
            return null;
        }
    }

    @Override
    public JacocoBuildAction getPreviousResult() {
        return JacocoBuildAction.getPreviousResult(this.owner);
    }

    static JacocoBuildAction getPreviousResult(AbstractBuild<?, ?> start) {
        JacocoBuildAction r;
        AbstractBuild b = start;
        do {
            if ((b = (AbstractBuild)b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.FAILURE || (r = (JacocoBuildAction)b.getAction(JacocoBuildAction.class)) == null);
        return r;
    }

    public static JacocoBuildAction load(AbstractBuild<?, ?> owner, Rule rule, JacocoHealthReportThresholds thresholds, BuildListener listener, FilePath actualBuildDirRoot, String[] includes, String[] excludes) throws IOException {
        PrintStream logger = listener.getLogger();
        Map<CoverageElement.Type, Coverage> ratios = null;
        ratios = JacocoBuildAction.loadRatios(actualBuildDirRoot, ratios, includes, excludes);
        return new JacocoBuildAction(owner, rule, ratios, thresholds, listener, includes, excludes);
    }

    private static Map<CoverageElement.Type, Coverage> loadRatios(FilePath actualBuildDirRoot, Map<CoverageElement.Type, Coverage> ratios, String[] includes, String[] excludes) throws IOException {
        if (ratios == null) {
            ratios = new LinkedHashMap<CoverageElement.Type, Coverage>();
        }
        IBundleCoverage bundleCoverage = null;
        ExecutionFileLoader efl = JacocoBuildAction.getJacocoReports(actualBuildDirRoot, includes, excludes);
        bundleCoverage = efl.getBundleCoverage();
        Coverage ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getClassCounter().getMissedCount(), bundleCoverage.getClassCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.CLASS, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getBranchCounter().getMissedCount(), bundleCoverage.getBranchCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.BRANCH, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getInstructionCounter().getMissedCount(), bundleCoverage.getInstructionCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.INSTRUCTION, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getMethodCounter().getMissedCount(), bundleCoverage.getMethodCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.METHOD, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getComplexityCounter().getMissedCount(), bundleCoverage.getComplexityCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.COMPLEXITY, ratio);
        ratio = new Coverage();
        ratio.accumulatePP(bundleCoverage.getLineCounter().getMissedCount(), bundleCoverage.getLineCounter().getCoveredCount());
        ratios.put(CoverageElement.Type.LINE, ratio);
        return ratios;
    }
}

