/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jacoco;

import edu.emory.mathcs.backport.java.util.Arrays;
import hudson.FilePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.maven.FileFilter;

public class ExecutionFileLoader
implements Serializable {
    private String name;
    private FilePath srcDir;
    private FilePath classDir;
    private FilePath execFile;
    private FilePath generatedHTMLsDir;
    private String[] includes;
    private String[] excludes;
    private String title;
    private ExecutionDataStore executionDataStore;
    private SessionInfoStore sessionInfoStore;
    private IBundleCoverage bundleCoverage;
    private ArrayList<FilePath> execFiles = new ArrayList();

    public void addExecFile(FilePath execFile) {
        this.execFiles.add(execFile);
    }

    public IBundleCoverage getBundleCoverage() {
        return this.bundleCoverage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBundleCoverage(IBundleCoverage bundleCoverage) {
        this.bundleCoverage = bundleCoverage;
    }

    public FilePath getGeneratedHTMLsDir() {
        return this.generatedHTMLsDir;
    }

    public void setGeneratedHTMLsDir(FilePath generatedHTMLsDir) {
        this.generatedHTMLsDir = generatedHTMLsDir;
    }

    public FilePath getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(FilePath srcDir) {
        this.srcDir = srcDir;
    }

    public FilePath getClassDir() {
        return this.classDir;
    }

    public void setClassDir(FilePath classDir) {
        this.classDir = classDir;
    }

    public FilePath getExecFile() {
        return this.execFile;
    }

    public void setExecFile(FilePath execFile) {
        this.execFile = execFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExecutionData() throws IOException {
        this.executionDataStore = new ExecutionDataStore();
        this.sessionInfoStore = new SessionInfoStore();
        Iterator<FilePath> i = this.execFiles.iterator();
        while (i.hasNext()) {
            FileInputStream isc = null;
            try {
                File executionDataFile = new File(i.next().getRemote());
                FileInputStream fis = new FileInputStream(executionDataFile);
                ExecutionDataReader reader = new ExecutionDataReader((InputStream)fis);
                reader.setSessionInfoVisitor((ISessionInfoVisitor)this.sessionInfoStore);
                reader.setExecutionDataVisitor((IExecutionDataVisitor)this.executionDataStore);
                reader.read();
                isc = fis;
                FileUtils.close((InputStream)isc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                FileUtils.close(isc);
            }
        }
    }

    private IBundleCoverage analyzeStructure() throws IOException {
        File classDirectory = new File(this.classDir.getRemote());
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, (ICoverageVisitor)coverageBuilder);
        if (this.includes == null || "".equals(this.includes[0])) {
            String[] in = new String[]{"**"};
            this.includes = in;
        }
        if (this.excludes == null || "".equals(this.excludes[0])) {
            String[] ex = new String[]{"{0}"};
            this.excludes = ex;
        }
        FileFilter fileFilter = new FileFilter(Arrays.asList((Object[])this.includes), Arrays.asList((Object[])this.excludes));
        List filesToAnalyze = org.codehaus.plexus.util.FileUtils.getFiles((File)classDirectory, (String)fileFilter.getIncludes(), (String)fileFilter.getExcludes());
        for (File file : filesToAnalyze) {
            analyzer.analyzeAll(file);
        }
        return coverageBuilder.getBundle(this.name);
    }

    public IBundleCoverage loadBundleCoverage() throws IOException {
        this.loadExecutionData();
        this.bundleCoverage = this.analyzeStructure();
        return this.bundleCoverage;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }
}

