/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.GitUtils;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SubmoduleConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    String submoduleName;
    String[] branches;

    public String getSubmoduleName() {
        return this.submoduleName;
    }

    public void setSubmoduleName(String submoduleName) {
        this.submoduleName = submoduleName;
    }

    public String[] getBranches() {
        return this.branches;
    }

    public void setBranches(String[] branches) {
        this.branches = branches;
    }

    public boolean revisionMatchesInterest(Revision r) {
        for (Branch br : r.getBranches()) {
            if (!this.branchMatchesInterest(br)) continue;
            return true;
        }
        return false;
    }

    public boolean branchMatchesInterest(Branch br) {
        for (String regex : this.branches) {
            if (Pattern.matches(regex, br.getName())) continue;
            return false;
        }
        return true;
    }

    public String getBranchesString() {
        String ret = "";
        for (String branch : this.branches) {
            if (ret.length() > 0) {
                ret = ret + ",";
            }
            ret = ret + branch;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmoduleConfig that = (SubmoduleConfig)o;
        if (!GitUtils.isEqualArray(this.branches, that.branches)) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.submoduleName, (Object)that.submoduleName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object[])this.branches).append((Object)this.submoduleName).toHashCode();
    }
}

