/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.Util;
import hudson.model.Action;
import hudson.model.Api;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean(defaultVisibility=999)
public class BuildData
implements Action,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public Map<String, Build> buildsByBranchName = new HashMap<String, Build>();
    public Build lastBuild;

    public String getDisplayName() {
        return "Git Build Data";
    }

    public String getIconFileName() {
        return "/plugin/git/icons/git-32x32.png";
    }

    public String getUrlName() {
        return "git";
    }

    public Object readResolve() {
        HashMap<String, Build> newBuildsByBranchName = new HashMap<String, Build>();
        for (Map.Entry<String, Build> buildByBranchName : this.buildsByBranchName.entrySet()) {
            String branchName = Util.fixNull((String)buildByBranchName.getKey());
            Build build = buildByBranchName.getValue();
            newBuildsByBranchName.put(branchName, build);
        }
        this.buildsByBranchName = newBuildsByBranchName;
        return this;
    }

    public boolean hasBeenBuilt(ObjectId sha1) {
        try {
            for (Build b : this.buildsByBranchName.values()) {
                if (!b.revision.getSha1().equals((AnyObjectId)sha1)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void saveBuild(Build build) {
        this.lastBuild = build;
        for (Branch branch : build.revision.getBranches()) {
            this.buildsByBranchName.put(Util.fixNull((String)branch.getName()), build);
        }
    }

    public Build getLastBuildOfBranch(String branch) {
        return this.buildsByBranchName.get(branch);
    }

    @Exported
    public Revision getLastBuiltRevision() {
        return this.lastBuild == null ? null : this.lastBuild.revision;
    }

    @Exported
    public Map<String, Build> getBuildsByBranchName() {
        return this.buildsByBranchName;
    }

    public BuildData clone() {
        BuildData clone;
        try {
            clone = (BuildData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning BuildData", e);
        }
        IdentityHashMap<Build, Build> clonedBuilds = new IdentityHashMap<Build, Build>();
        clone.buildsByBranchName = new HashMap<String, Build>();
        for (Map.Entry<String, Build> buildByBranchName : this.buildsByBranchName.entrySet()) {
            Build build;
            Build clonedBuild;
            String branchName = buildByBranchName.getKey();
            if (branchName == null) {
                branchName = "";
            }
            if ((clonedBuild = (Build)clonedBuilds.get(build = buildByBranchName.getValue())) == null) {
                clonedBuild = build.clone();
                clonedBuilds.put(build, clonedBuild);
            }
            clone.buildsByBranchName.put(branchName, clonedBuild);
        }
        if (this.lastBuild != null) {
            clone.lastBuild = (Build)clonedBuilds.get(this.lastBuild);
            if (clone.lastBuild == null) {
                clone.lastBuild = this.lastBuild.clone();
                clonedBuilds.put(this.lastBuild, clone.lastBuild);
            }
        }
        return clone;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String toString() {
        return super.toString() + "[buildsByBranchName=" + this.buildsByBranchName + ",lastBuild=" + this.lastBuild + "]";
    }
}

