/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.windows;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.lifecycle.WindowsSlaveInstaller;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.os.windows.Messages;
import hudson.os.windows.WindowsRemoteFileSystem;
import hudson.os.windows.WindowsRemoteLauncher;
import hudson.remoting.Channel;
import hudson.remoting.SocketInputStream;
import hudson.remoting.SocketOutputStream;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.tools.JDKInstaller;
import hudson.util.IOUtils;
import hudson.util.Secret;
import hudson.util.jna.DotNet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIDefaultAuthInfoImpl;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JISession;
import org.jvnet.hudson.remcom.WindowsRemoteProcessLauncher;
import org.jvnet.hudson.wmi.SWbemServices;
import org.jvnet.hudson.wmi.WMI;
import org.jvnet.hudson.wmi.Win32Service;
import org.kohsuke.stapler.DataBoundConstructor;

public class ManagedWindowsServiceLauncher
extends ComputerLauncher {
    public final String userName;
    public final Secret password;

    @DataBoundConstructor
    public ManagedWindowsServiceLauncher(String userName, String password) {
        this.userName = userName;
        this.password = Secret.fromString((String)password);
    }

    private JIDefaultAuthInfoImpl createAuth() {
        String[] tokens = this.userName.split("\\\\");
        if (tokens.length == 2) {
            return new JIDefaultAuthInfoImpl(tokens[0], tokens[1], Secret.toString((Secret)this.password));
        }
        return new JIDefaultAuthInfoImpl("", this.userName, Secret.toString((Secret)this.password));
    }

    private NtlmPasswordAuthentication createSmbAuth() {
        JIDefaultAuthInfoImpl auth = this.createAuth();
        return new NtlmPasswordAuthentication(auth.getDomain(), auth.getUserName(), auth.getPassword());
    }

    public void launch(final SlaveComputer computer, final TaskListener listener) throws IOException, InterruptedException {
        try {
            PrintStream logger = listener.getLogger();
            String name = this.determineHost((Computer)computer);
            logger.println(Messages.ManagedWindowsServiceLauncher_ConnectingTo(name));
            InetAddress host = InetAddress.getByName(name);
            try {
                Socket s = new Socket();
                s.connect(new InetSocketAddress(host, 135), 5000);
                s.close();
            }
            catch (IOException e) {
                logger.println("Failed to connect to port 135 of " + name + ". Is Windows firewall blocking this port? Or did you disable DCOM service?");
            }
            JIDefaultAuthInfoImpl auth = this.createAuth();
            JISession session = JISession.createSession((IJIAuthInfo)auth);
            session.setGlobalSocketTimeout(60000);
            SWbemServices services = WMI.connect((JISession)session, (String)name);
            String path = computer.getNode().getRemoteFS();
            if (path.indexOf(58) == -1) {
                throw new IOException("Remote file system root path of the slave needs to be absolute: " + path);
            }
            SmbFile remoteRoot = new SmbFile("smb://" + name + "/" + path.replace('\\', '/').replace(':', '$') + "/", this.createSmbAuth());
            if (!remoteRoot.exists()) {
                remoteRoot.mkdirs();
            }
            try {
                logger.println("Checking if Java exists");
                WindowsRemoteProcessLauncher wrpl = new WindowsRemoteProcessLauncher(name, (IJIAuthInfo)auth);
                Process proc = wrpl.launch("java -fullversion", "c:\\");
                proc.getOutputStream().close();
                IOUtils.copy((InputStream)proc.getInputStream(), (OutputStream)logger);
                proc.getInputStream().close();
                int exitCode = proc.waitFor();
                if (exitCode == 1) {
                    logger.println("No Java found. Downloading JDK");
                    JDKInstaller jdki = new JDKInstaller("jdk-6u16-oth-JPR@CDS-CDS_Developer", true);
                    URL jdk = jdki.locate(listener, JDKInstaller.Platform.WINDOWS, JDKInstaller.CPU.i386);
                    listener.getLogger().println("Installing JDK");
                    Util.copyStreamAndClose((InputStream)jdk.openStream(), (OutputStream)new SmbFile(remoteRoot, "jdk.exe").getOutputStream());
                    String javaDir = path + "\\jdk";
                    WindowsRemoteFileSystem fs = new WindowsRemoteFileSystem(name, this.createSmbAuth());
                    fs.mkdirs(javaDir);
                    jdki.install((Launcher)new WindowsRemoteLauncher(listener, wrpl), JDKInstaller.Platform.WINDOWS, (JDKInstaller.FileSystem)fs, listener, javaDir, path + "\\jdk.exe");
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.error("Failed to prepare Java"));
            }
            String id = WindowsSlaveInstaller.generateServiceId((String)path);
            Win32Service slaveService = services.getService(id);
            if (slaveService == null) {
                logger.println(Messages.ManagedWindowsServiceLauncher_InstallingSlaveService());
                if (!DotNet.isInstalled((int)2, (int)0, (String)name, (IJIAuthInfo)auth)) {
                    logger.println(Messages.ManagedWindowsServiceLauncher_DotNetRequired());
                    return;
                }
                logger.println(Messages.ManagedWindowsServiceLauncher_CopyingSlaveExe());
                Util.copyStreamAndClose((InputStream)((Object)((Object)this)).getClass().getResource("/windows-service/hudson.exe").openStream(), (OutputStream)new SmbFile(remoteRoot, "hudson-slave.exe").getOutputStream());
                this.copySlaveJar(logger, remoteRoot);
                logger.println(Messages.ManagedWindowsServiceLauncher_CopyingSlaveXml());
                String xml = WindowsSlaveInstaller.generateSlaveXml((String)id, (String)"javaw.exe", (String)"-tcp %BASE%\\port.txt");
                Util.copyStreamAndClose((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), (OutputStream)new SmbFile(remoteRoot, "hudson-slave.xml").getOutputStream());
                logger.println(Messages.ManagedWindowsServiceLauncher_RegisteringService());
                Document dom = new SAXReader().read((Reader)new StringReader(xml));
                Win32Service svc = (Win32Service)services.Get("Win32_Service").cast(Win32Service.class);
                int r = svc.Create(id, dom.selectSingleNode("/service/name").getText() + " at " + path, path + "\\hudson-slave.exe", 16, 0, "Manual", true);
                if (r != 0) {
                    listener.error("Failed to create a service: " + svc.getErrorMessage(r));
                    return;
                }
                slaveService = services.getService(id);
            } else {
                this.copySlaveJar(logger, remoteRoot);
            }
            logger.println(Messages.ManagedWindowsServiceLauncher_StartingService());
            slaveService.start();
            logger.println(Messages.ManagedWindowsServiceLauncher_WaitingForService());
            SmbFile portFile = new SmbFile(remoteRoot, "port.txt");
            int i = 0;
            while (!portFile.exists()) {
                if (i >= 30) {
                    listener.error(Messages.ManagedWindowsServiceLauncher_ServiceDidntRespond());
                    return;
                }
                Thread.sleep(1000L);
                ++i;
            }
            int p = this.readSmbFile(portFile);
            logger.println(Messages.ManagedWindowsServiceLauncher_ConnectingToPort(p));
            Socket s = new Socket(name, p);
            computer.setChannel((InputStream)new BufferedInputStream((InputStream)new SocketInputStream(s)), (OutputStream)new BufferedOutputStream((OutputStream)new SocketOutputStream(s)), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    ManagedWindowsServiceLauncher.this.afterDisconnect(computer, listener);
                }
            });
        }
        catch (SmbException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (JIException e) {
            if (e.getErrorCode() == 5) {
                e.printStackTrace(listener.error(Messages.ManagedWindowsServiceLauncher_AccessDenied()));
            } else {
                e.printStackTrace(listener.error(e.getMessage()));
            }
        }
        catch (DocumentException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    protected String determineHost(Computer c) throws IOException, InterruptedException {
        return c.getName();
    }

    private void copySlaveJar(PrintStream logger, SmbFile remoteRoot) throws IOException {
        logger.println("Copying slave.jar");
        Util.copyStreamAndClose((InputStream)Hudson.getInstance().getJnlpJars("slave.jar").getURL().openStream(), (OutputStream)new SmbFile(remoteRoot, "slave.jar").getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSmbFile(SmbFile f) throws IOException {
        InputStream in = null;
        try {
            in = f.getInputStream();
            int n = Integer.parseInt(IOUtils.toString((InputStream)in));
            return n;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        try {
            JIDefaultAuthInfoImpl auth = this.createAuth();
            JISession session = JISession.createSession((IJIAuthInfo)auth);
            session.setGlobalSocketTimeout(60000);
            SWbemServices services = WMI.connect((JISession)session, (String)computer.getName());
            Win32Service slaveService = services.getService("hudsonslave");
            if (slaveService != null) {
                listener.getLogger().println(Messages.ManagedWindowsServiceLauncher_StoppingService());
                slaveService.StopService();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (JIException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    static {
        Logger.getLogger("org.jinterop").setLevel(Level.WARNING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return Messages.ManagedWindowsServiceLauncher_DisplayName();
        }
    }
}

