/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.websocket;

import cats.Applicative;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.effect.kernel.Unique;
import cats.syntax.package;
import fs2.Stream;
import java.io.Serializable;
import org.http4s.Response;
import org.http4s.server.websocket.WebSocketBuilder2$;
import org.http4s.websocket.WebSocket;
import org.http4s.websocket.WebSocketCombinedPipe$;
import org.http4s.websocket.WebSocketContext;
import org.http4s.websocket.WebSocketContext$;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketFrameDefragmenter$;
import org.http4s.websocket.WebSocketSeparatePipe$;
import org.typelevel.vault.Key;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;

public abstract class WebSocketBuilder2<F> {
    private final List headers;
    private final F onNonWebSocketRequest;
    private final F onHandshakeFailure;
    private final F onClose;
    private final boolean filterPingPongs;
    private final boolean defragFrame;
    private final Key webSocketKey;
    private final Applicative<F> evidence$1;
    private final Function1<WebSocketFrame, Object> isPingPong;

    public static <F> Object apply(Applicative<F> applicative, Unique<F> unique) {
        return WebSocketBuilder2$.MODULE$.apply(applicative, unique);
    }

    public static <F> WebSocketBuilder2<F> apply(Key<WebSocketContext<F>> key, Applicative<F> applicative) {
        return WebSocketBuilder2$.MODULE$.apply(key, applicative);
    }

    public WebSocketBuilder2(List headers, Object onNonWebSocketRequest, Object onHandshakeFailure, Object onClose, boolean filterPingPongs, boolean defragFrame, Key<WebSocketContext<F>> webSocketKey, Applicative<F> evidence$1) {
        this.headers = headers;
        this.onNonWebSocketRequest = onNonWebSocketRequest;
        this.onHandshakeFailure = onHandshakeFailure;
        this.onClose = onClose;
        this.filterPingPongs = filterPingPongs;
        this.defragFrame = defragFrame;
        this.webSocketKey = webSocketKey;
        this.evidence$1 = evidence$1;
        this.isPingPong = (Function1 & Serializable)x$1 -> {
            WebSocketFrame webSocketFrame = x$1;
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                return true;
            }
            return webSocketFrame instanceof WebSocketFrame.Pong;
        };
    }

    public Key<WebSocketContext<F>> webSocketKey() {
        return this.webSocketKey;
    }

    public WebSocketBuilder2(List headers, Object onNonWebSocketRequest, Object onHandshakeFailure, Object onClose, boolean filterPingPongs, Key<WebSocketContext<F>> webSocketKey, Applicative<F> evidence$1) {
        this(headers, onNonWebSocketRequest, onHandshakeFailure, onClose, filterPingPongs, false, webSocketKey, evidence$1);
    }

    private WebSocketBuilder2<F> copy(List headers, F onNonWebSocketRequest, F onHandshakeFailure, F onClose, boolean filterPingPongs, boolean defragFrame, Key<WebSocketContext<F>> webSocketKey) {
        return WebSocketBuilder2$.MODULE$.org$http4s$server$websocket$WebSocketBuilder2$$$impl(headers, onNonWebSocketRequest, onHandshakeFailure, onClose, filterPingPongs, defragFrame, webSocketKey, this.evidence$1);
    }

    private List copy$default$1() {
        return this.headers;
    }

    private F copy$default$2() {
        return this.onNonWebSocketRequest;
    }

    private F copy$default$3() {
        return this.onHandshakeFailure;
    }

    private F copy$default$4() {
        return this.onClose;
    }

    private boolean copy$default$5() {
        return this.filterPingPongs;
    }

    private boolean copy$default$6() {
        return this.defragFrame;
    }

    private Key<WebSocketContext<F>> copy$default$7() {
        return this.webSocketKey();
    }

    public WebSocketBuilder2<F> withHeaders(List headers) {
        return this.copy(headers, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public WebSocketBuilder2<F> withOnNonWebSocketRequest(F onNonWebSocketRequest) {
        return this.copy(this.copy$default$1(), onNonWebSocketRequest, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public WebSocketBuilder2<F> withOnHandshakeFailure(F onHandshakeFailure) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), onHandshakeFailure, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public WebSocketBuilder2<F> withOnClose(F onClose) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), onClose, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public WebSocketBuilder2<F> withFilterPingPongs(boolean filterPingPongs) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), filterPingPongs, this.copy$default$6(), this.copy$default$7());
    }

    public WebSocketBuilder2<F> withDefragment(boolean defragFrame) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), defragFrame, this.copy$default$7());
    }

    public <G> WebSocketBuilder2<G> imapK(FunctionK<F, G> fk, FunctionK<G, F> gk, Applicative<G> evidence$1) {
        return WebSocketBuilder2$.MODULE$.org$http4s$server$websocket$WebSocketBuilder2$$$impl(this.headers, package.all$.MODULE$.toFunctorOps(fk.apply(this.onNonWebSocketRequest), evidence$1).map((Function1 & Serializable)_$3 -> _$3.mapK(fk)), package.all$.MODULE$.toFunctorOps(fk.apply(this.onHandshakeFailure), evidence$1).map((Function1 & Serializable)_$4 -> _$4.mapK(fk)), fk.apply(this.onClose), this.filterPingPongs, this.defragFrame, this.webSocketKey().imap((Function1 & Serializable)_$5 -> _$5.imapK(fk, gk, (Functor)evidence$1), (Function1 & Serializable)_$6 -> _$6.imapK(gk, fk, this.evidence$1)), evidence$1);
    }

    private F buildResponse(WebSocket<F> webSocket) {
        return (F)package.all$.MODULE$.toFunctorOps(this.onNonWebSocketRequest, this.evidence$1).map((Function1 & Serializable)_$7 -> (Response)_$7.withAttribute(this.webSocketKey(), (Object)WebSocketContext$.MODULE$.apply(webSocket, this.headers, this.onHandshakeFailure)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public F build(Function1<Stream<F, WebSocketFrame>, Stream<F, WebSocketFrame>> sendReceive) {
        Function1 function1;
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.filterPingPongs, this.defragFrame);
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl2 = sp2._2$mcZ$sp();
        if (bl && !bl2) {
            function1 = sendReceive.compose(this.filterPingPongFrames());
        } else if (!bl && !bl2) {
            function1 = sendReceive;
        } else if (bl && bl2) {
            function1 = sendReceive.compose(WebSocketFrameDefragmenter$.MODULE$.defragFragment().compose(this.filterPingPongFrames()));
        } else {
            if (bl || !bl2) throw new MatchError((Object)sp2);
            function1 = sendReceive.compose(WebSocketFrameDefragmenter$.MODULE$.defragFragment());
        }
        Function1 finalSendReceive = function1;
        return this.buildResponse((WebSocket<F>)WebSocketCombinedPipe$.MODULE$.apply(finalSendReceive, this.onClose));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public F build(Stream<F, WebSocketFrame> send, Function1<Stream<F, WebSocketFrame>, Stream<F, BoxedUnit>> receive) {
        Function1 function1;
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.filterPingPongs, this.defragFrame);
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl = sp2._1$mcZ$sp();
        boolean bl2 = sp2._2$mcZ$sp();
        if (bl && !bl2) {
            function1 = receive.compose(this.filterPingPongFrames());
        } else if (!bl && !bl2) {
            function1 = receive;
        } else if (bl && bl2) {
            function1 = receive.compose(WebSocketFrameDefragmenter$.MODULE$.defragFragment().compose(this.filterPingPongFrames()));
        } else {
            if (bl || !bl2) throw new MatchError((Object)sp2);
            function1 = receive.compose(WebSocketFrameDefragmenter$.MODULE$.defragFragment());
        }
        Function1 finalReceive = function1;
        return this.buildResponse((WebSocket<F>)WebSocketSeparatePipe$.MODULE$.apply(send, finalReceive, this.onClose));
    }

    private Function1<Stream<F, WebSocketFrame>, Stream<F, WebSocketFrame>> filterPingPongFrames() {
        return (Function1 & Serializable)inputStream -> inputStream.filterNot(this.isPingPong);
    }
}

