/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;

public class ReportUriDirective
extends Directive {
    private List<String> uris_ = new ArrayList<String>();

    public ReportUriDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String value : values) {
            this.addUri(value, index, errors);
            ++index;
        }
        if (this.getValues().isEmpty()) {
            errors.add(Policy.Severity.Error, "The report-uri value requires at least one value", -1);
        }
    }

    private void addUri(String uri, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.uris_.contains(uri)) {
            errors.add(Policy.Severity.Info, "Duplicate report-to URI; are you sure you intend to get multiple copies of each report?", index);
        }
        this.uris_.add(uri);
    }

    public List<String> getUris() {
        return Collections.unmodifiableList(this.uris_);
    }
}

