/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.htmlunit.csp.Policy;

public class Directive {
    public static final Predicate<String> IS_DIRECTIVE_NAME = Pattern.compile("^[A-Za-z0-9\\-]+$").asPredicate();
    public static final Predicate<String> containsNonDirectiveCharacter = Pattern.compile("[\t\n\f\r ,;]").asPredicate();
    private List<String> values_ = new ArrayList<String>();

    protected void addValue(String value) {
        Policy.enforceAscii(value);
        if (containsNonDirectiveCharacter.test(value)) {
            throw new IllegalArgumentException("values must not contain whitespace, ',', or ';'");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("values must not be empty");
        }
        this.values_.add(value);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values_);
    }

    protected Directive(List<String> values) {
        for (String value : values) {
            this.addValue(value);
        }
    }

    protected void removeValueIgnoreCase(String value) {
        String lowcaseValue = value.toLowerCase(Locale.ROOT);
        ArrayList<String> copy = new ArrayList<String>(this.values_.size());
        for (String existing : this.values_) {
            if (existing.toLowerCase(Locale.ROOT).equals(lowcaseValue)) continue;
            copy.add(existing);
        }
        this.values_ = copy;
    }

    @FunctionalInterface
    public static interface DirectiveErrorConsumer {
        public static final DirectiveErrorConsumer ignored = (severity, message, valueIndex) -> {};

        public void add(Policy.Severity var1, String var2, int var3);
    }
}

