/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.List;
import java.util.Map;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Delegator;
import org.htmlunit.corejs.javascript.Hashtable;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeCollectionIterator;
import org.htmlunit.corejs.javascript.NativeSet;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public class NativeMap
extends ScriptableObject {
    private static final long serialVersionUID = 1171922614280016891L;
    private static final String CLASS_NAME = "Map";
    static final String ITERATOR_TAG = "Map Iterator";
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfMap = false;

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 0, 2, NativeMap::jsConstructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.defineConstructorMethod(scope, "groupBy", 2, NativeMap::jsGroupBy, 2);
        constructor.definePrototypeMethod(scope, "set", 2, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "set").js_set(NativeMap.key(args), args.length > 1 ? args[1] : Undefined.instance), 2, 3);
        constructor.definePrototypeMethod(scope, "delete", 1, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "delete").js_delete(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "get", 1, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "get").js_get(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "has", 1, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "has").js_has(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "clear", 0, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "clear").js_clear(), 2, 3);
        constructor.definePrototypeMethod(scope, "keys", 0, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "keys").js_iterator(scope, NativeCollectionIterator.Type.KEYS), 2, 3);
        constructor.definePrototypeMethod(scope, "values", 0, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "values").js_iterator(scope, NativeCollectionIterator.Type.VALUES), 2, 3);
        constructor.definePrototypeMethod(scope, "forEach", 1, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "forEach").js_forEach(lcx, lscope, args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance), 2, 3);
        constructor.definePrototypeMethod(scope, "entries", 0, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "entries").js_iterator(scope, NativeCollectionIterator.Type.BOTH), 2, 3);
        constructor.definePrototypeAlias("entries", SymbolKey.ITERATOR, 2);
        ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
        desc.put("enumerable", (Scriptable)desc, (Object)Boolean.FALSE);
        desc.put("configurable", (Scriptable)desc, (Object)Boolean.TRUE);
        LambdaFunction sizeFunc = new LambdaFunction(scope, "get size", 0, (lcx, lscope, thisObj, args) -> NativeMap.realThis(thisObj, "size").js_getSize());
        sizeFunc.setPrototypeProperty(Undefined.instance);
        desc.put("get", (Scriptable)desc, (Object)sizeFunc);
        constructor.definePrototypeProperty(cx, "size", desc);
        constructor.definePrototypeProperty(cx, NativeSet.GETSIZE, desc);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
        }
        return constructor;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args) {
        NativeMap nm = new NativeMap();
        nm.instanceOfMap = true;
        if (args.length > 0) {
            NativeMap.loadFromIterable(cx, scope, nm, NativeMap.key(args));
        }
        return nm;
    }

    private static Object jsGroupBy(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object items = args.length < 1 ? Undefined.instance : args[0];
        Object callback = args.length < 2 ? Undefined.instance : args[1];
        Map<Object, List<Object>> groups = AbstractEcmaObjectOperations.groupBy(cx, scope, CLASS_NAME, "groupBy", items, callback, AbstractEcmaObjectOperations.KEY_COERCION.COLLECTION);
        NativeMap map = (NativeMap)cx.newObject(scope, CLASS_NAME);
        for (Map.Entry<Object, List<Object>> entry : groups.entrySet()) {
            Scriptable elements = cx.newArray(scope, entry.getValue().toArray());
            map.entries.put(entry.getKey(), elements);
        }
        return map;
    }

    private Object js_set(Object k, Object v) {
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = ScriptRuntime.zeroObj;
        }
        this.entries.put(key, v);
        return this;
    }

    private Object js_delete(Object arg) {
        return this.entries.deleteEntry(arg);
    }

    private Object js_get(Object arg) {
        Hashtable.Entry entry = this.entries.getEntry(arg);
        if (entry == null) {
            return Undefined.instance;
        }
        return entry.value;
    }

    private Object js_has(Object arg) {
        return this.entries.has(arg);
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", arg1, ScriptRuntime.typeof(arg1));
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = entry;
            f.call(cx, scope, thisObj, new Object[]{e.value, e.key, this});
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject map, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(arg1, cx, scope);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        Scriptable proto = ScriptableObject.getClassPrototype(scope, map.getClassName());
        Callable set = ScriptRuntime.getPropFunctionAndThis(proto, "set", cx, scope);
        ScriptRuntime.lastStoredScriptable(cx);
        ScriptRuntime.loadFromIterable(cx, scope, arg1, (Object key, Object value) -> set.call(cx, scope, map, new Object[]{key, value}));
    }

    private static NativeMap realThis(Scriptable thisObj, String name) {
        NativeMap nm = LambdaConstructor.convertThisObject(thisObj, NativeMap.class);
        if (!nm.instanceOfMap) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", name);
        }
        return nm;
    }

    static Object key(Object[] args) {
        if (args.length > 0) {
            Object key = args[0];
            if (key instanceof Delegator) {
                return ((Delegator)key).getDelegee();
            }
            return key;
        }
        return Undefined.instance;
    }
}

