/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EvaluatorException;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolScriptable;
import org.htmlunit.corejs.javascript.Undefined;

public class NativeObject
extends ScriptableObject
implements Map {
    private static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = "Object";
    private static final String CLASS_NAME = "Object";
    private static final int ConstructorId_getPrototypeOf = -1;
    private static final int ConstructorId_keys = -2;
    private static final int ConstructorId_getOwnPropertyNames = -3;
    private static final int ConstructorId_getOwnPropertyDescriptor = -4;
    private static final int ConstructorId_getOwnPropertyDescriptors = -5;
    private static final int ConstructorId_defineProperty = -6;
    private static final int ConstructorId_isExtensible = -7;
    private static final int ConstructorId_preventExtensions = -8;
    private static final int ConstructorId_defineProperties = -9;
    private static final int ConstructorId_create = -10;
    private static final int ConstructorId_isSealed = -11;
    private static final int ConstructorId_isFrozen = -12;
    private static final int ConstructorId_seal = -13;
    private static final int ConstructorId_freeze = -14;
    private static final int ConstructorId_getOwnPropertySymbols = -15;
    private static final int ConstructorId_assign = -16;
    private static final int ConstructorId_is = -17;
    private static final int ConstructorId_setPrototypeOf = -18;
    private static final int ConstructorId_entries = -19;
    private static final int ConstructorId_fromEntries = -20;
    private static final int ConstructorId_values = -21;
    private static final int ConstructorId_hasOwn = -22;
    private static final int ConstructorId_groupBy = -23;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int Id___defineGetter__ = 9;
    private static final int Id___defineSetter__ = 10;
    private static final int Id___lookupGetter__ = 11;
    private static final int Id___lookupSetter__ = 12;
    private static final int MAX_PROTOTYPE_ID = 12;

    static void init(Scriptable s, boolean sealed) {
        LambdaConstructor ctor = new LambdaConstructor(s, CLASS_NAME, 1, NativeObject::js_constructorCall, NativeObject::js_constructor){

            @Override
            public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
                return NativeObject.js_constructor(cx, scope, args);
            }
        };
        NativeObject.defOnCtor(ctor, s, "getPrototypeOf", 1, NativeObject::js_getPrototypeOf);
        NativeObject.defOnCtor(ctor, s, "setPrototypeOf", 2, NativeObject::js_setPrototypeOf);
        NativeObject.defOnCtor(ctor, s, "entries", 1, NativeObject::js_entries);
        NativeObject.defOnCtor(ctor, s, "fromEntries", 1, NativeObject::js_fromEntries);
        NativeObject.defOnCtor(ctor, s, "values", 1, NativeObject::js_values);
        NativeObject.defOnCtor(ctor, s, "hasOwn", 1, NativeObject::js_hasOwn);
        NativeObject.defOnCtor(ctor, s, "keys", 1, NativeObject::js_keys);
        NativeObject.defOnCtor(ctor, s, "getOwnPropertyNames", 1, NativeObject::js_getOwnPropertyNames);
        NativeObject.defOnCtor(ctor, s, "getOwnPropertySymbols", 1, NativeObject::js_getOwnPropertySymbols);
        NativeObject.defOnCtor(ctor, s, "getOwnPropertyDescriptor", 2, NativeObject::js_getOwnPropDesc);
        NativeObject.defOnCtor(ctor, s, "getOwnPropertyDescriptors", 1, NativeObject::js_getOwnPropDescs);
        NativeObject.defOnCtor(ctor, s, "defineProperty", 3, NativeObject::js_defineProperty);
        NativeObject.defOnCtor(ctor, s, "isExtensible", 1, NativeObject::js_isExtensible);
        NativeObject.defOnCtor(ctor, s, "preventExtensions", 1, NativeObject::js_preventExtensions);
        NativeObject.defOnCtor(ctor, s, "defineProperties", 2, NativeObject::js_defineProperties);
        NativeObject.defOnCtor(ctor, s, "create", 2, NativeObject::js_create);
        NativeObject.defOnCtor(ctor, s, "isSealed", 1, NativeObject::js_isSealed);
        NativeObject.defOnCtor(ctor, s, "isFrozen", 1, NativeObject::js_isFrozen);
        NativeObject.defOnCtor(ctor, s, "seal", 1, NativeObject::js_seal);
        NativeObject.defOnCtor(ctor, s, "freeze", 1, NativeObject::js_freeze);
        NativeObject.defOnCtor(ctor, s, "assign", 2, NativeObject::js_assign);
        NativeObject.defOnCtor(ctor, s, "is", 2, NativeObject::js_is);
        NativeObject.defOnCtor(ctor, s, "groupBy", 2, NativeObject::js_groupBy);
        NativeObject.defOnProto(ctor, s, "toString", 0, NativeObject::js_toString);
        NativeObject.defOnProto(ctor, s, "toLocaleString", 0, NativeObject::js_toLocaleString);
        NativeObject.defOnProto(ctor, s, "__lookupGetter__", 1, NativeObject::js_lookupGetter);
        NativeObject.defOnProto(ctor, s, "__lookupSetter__", 1, NativeObject::js_lookupSetter);
        NativeObject.defOnProto(ctor, s, "__defineGetter__", 2, NativeObject::js_defineGetter);
        NativeObject.defOnProto(ctor, s, "__defineSetter__", 2, NativeObject::js_defineSetter);
        NativeObject.defOnProto(ctor, s, "hasOwnProperty", 1, NativeObject::js_hasOwnProperty);
        NativeObject.defOnProto(ctor, s, "propertyIsEnumerable", 1, NativeObject::js_propertyIsEnumerable);
        NativeObject.defOnProto(ctor, s, "valueOf", 0, NativeObject::js_valueOf);
        NativeObject.defOnProto(ctor, s, "isPrototypeOf", 1, NativeObject::js_isPrototypeOf);
        NativeObject.defOnProto(ctor, s, "toSource", 0, ScriptRuntime::defaultObjectToSource);
        ctor.setPrototypePropertyAttributes(7);
        ScriptableObject.defineProperty(s, CLASS_NAME, ctor, 2);
        if (sealed) {
            ctor.sealObject();
            ((NativeObject)ctor.getPrototypeProperty()).sealObject();
        }
    }

    private static void defOnCtor(LambdaConstructor constructor, Scriptable scope, String name, int length, SerializableCallable target) {
        constructor.defineConstructorMethod(scope, name, length, null, target, 2, 3);
    }

    private static void defOnProto(LambdaConstructor constructor, Scriptable scope, String name, int length, SerializableCallable target) {
        constructor.definePrototypeMethod(scope, name, length, null, target, 2, 3);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    private static Scriptable js_constructorCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0 || args[0] == null || Undefined.isUndefined(args[0])) {
            return cx.newObject(scope);
        }
        return ScriptRuntime.toObject(cx, scope, args[0]);
    }

    private static Scriptable js_constructor(Context cx, Scriptable scope, Object[] args) {
        if (args.length == 0 || args[0] == null || Undefined.isUndefined(args[0])) {
            return cx.newObject(scope);
        }
        return ScriptRuntime.toObject(cx, scope, args[0]);
    }

    private static Object js_toLocaleString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (thisObj == null) {
            throw ScriptRuntime.notFunctionError(null);
        }
        Object toString = ScriptableObject.getProperty(thisObj, "toString");
        if (!(toString instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(toString);
        }
        Callable fun = (Callable)toString;
        return fun.call(cx, scope, thisObj, ScriptRuntime.emptyArgs);
    }

    private static Object js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (cx.hasFeature(4)) {
            String s = ScriptRuntime.defaultObjectToSource(cx, scope, thisObj, args);
            int L = s.length();
            if (L != 0 && s.charAt(0) == '(' && s.charAt(L - 1) == ')') {
                s = s.substring(1, L - 1);
            }
            return s;
        }
        return ScriptRuntime.defaultObjectToString(thisObj);
    }

    private static Object js_valueOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (thisObj == null || Undefined.isUndefined(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg." + (thisObj == null ? "null" : "undef") + ".to.object", new Object[0]);
        }
        return thisObj;
    }

    private static Object js_hasOwnProperty(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (thisObj == null || Undefined.isUndefined(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg." + (thisObj == null ? "null" : "undef") + ".to.object", new Object[0]);
        }
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        return AbstractEcmaObjectOperations.hasOwnProperty(cx, thisObj, arg);
    }

    private static Object js_propertyIsEnumerable(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean result;
        Object arg;
        if (thisObj == null || Undefined.isUndefined(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg." + (thisObj == null ? "null" : "undef") + ".to.object", new Object[0]);
        }
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (arg instanceof Symbol) {
            result = ((SymbolScriptable)((Object)thisObj)).has((Symbol)arg, thisObj);
            result = result && NativeObject.isEnumerable((Symbol)arg, (Object)thisObj);
        } else {
            ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(arg);
            try {
                result = s.stringId == null ? (result = thisObj.has(s.index, thisObj)) && NativeObject.isEnumerable(s.index, (Object)thisObj) : (result = thisObj.has(s.stringId, thisObj)) && NativeObject.isEnumerable(s.stringId, (Object)thisObj);
            }
            catch (EvaluatorException ee) {
                Object[] objectArray = new Object[1];
                Object object2 = objectArray[0] = s.stringId == null ? Integer.toString(s.index) : s.stringId;
                if (ee.getMessage().startsWith(ScriptRuntime.getMessageById("msg.prop.not.found", objectArray))) {
                    result = false;
                }
                throw ee;
            }
        }
        return ScriptRuntime.wrapBoolean(result);
    }

    private static Object js_isPrototypeOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (thisObj == null || Undefined.isUndefined(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg." + (thisObj == null ? "null" : "undef") + ".to.object", new Object[0]);
        }
        boolean result = false;
        if (args.length != 0 && args[0] instanceof Scriptable) {
            Scriptable v = (Scriptable)args[0];
            do {
                if ((v = v.getPrototype()) != thisObj) continue;
                result = true;
                break;
            } while (v != null);
        }
        return ScriptRuntime.wrapBoolean(result);
    }

    private static Object js_defineGetter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeObject.js_defineGetterOrSetter(cx, scope, false, thisObj, args);
    }

    private static Object js_defineSetter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeObject.js_defineGetterOrSetter(cx, scope, true, thisObj, args);
    }

    private static Object js_defineGetterOrSetter(Context cx, Scriptable scope, boolean isSetter, Scriptable thisObj, Object[] args) {
        if (args.length < 2 || !(args[1] instanceof Callable)) {
            Object badArg = args.length >= 2 ? args[1] : Undefined.instance;
            throw ScriptRuntime.notFunctionError(badArg);
        }
        if (!(thisObj instanceof ScriptableObject)) {
            throw Context.reportRuntimeErrorById("msg.extend.scriptable", thisObj == null ? "null" : thisObj.getClass().getName(), String.valueOf(args[0]));
        }
        ScriptableObject so = (ScriptableObject)thisObj;
        ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(args[0]);
        int index = s.stringId != null ? 0 : s.index;
        Callable getterOrSetter = (Callable)args[1];
        so.setGetterOrSetter(s.stringId, index, getterOrSetter, isSetter);
        if (so instanceof NativeArray) {
            ((NativeArray)so).setDenseOnly(false);
        }
        return Undefined.instance;
    }

    private static Object js_lookupGetter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeObject.js_lookupGetterOrSetter(cx, scope, false, thisObj, args);
    }

    private static Object js_lookupSetter(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeObject.js_lookupGetterOrSetter(cx, scope, true, thisObj, args);
    }

    private static Object js_lookupGetterOrSetter(Context cx, Scriptable scope, boolean isSetter, Scriptable thisObj, Object[] args) {
        Scriptable v;
        Object gs;
        int index;
        if (args.length < 1 || !(thisObj instanceof ScriptableObject)) {
            return Undefined.instance;
        }
        ScriptableObject so = (ScriptableObject)thisObj;
        ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(args[0]);
        int n = index = s.stringId != null ? 0 : s.index;
        while ((gs = so.getGetterOrSetter(s.stringId, index, scope, isSetter)) == null && (v = so.getPrototype()) != null && v instanceof ScriptableObject) {
            so = (ScriptableObject)v;
        }
        if (gs != null) {
            return gs;
        }
        return Undefined.instance;
    }

    private static Object js_getPrototypeOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable obj = NativeObject.getCompatibleObject(cx, scope, arg);
        return obj.getPrototype();
    }

    private static Object js_setPrototypeOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Scriptable proto;
        if (args.length < 2) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Object.setPrototypeOf", "2", Integer.toString(args.length));
        }
        Scriptable scriptable = proto = args[1] == null ? null : NativeObject.ensureScriptable(args[1]);
        if (proto instanceof Symbol) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(proto));
        }
        Object arg0 = args[0];
        ScriptRuntimeES6.requireObjectCoercible(cx, arg0, OBJECT_TAG, "setPrototypeOf");
        if (!(arg0 instanceof ScriptableObject)) {
            return arg0;
        }
        ScriptableObject obj = (ScriptableObject)arg0;
        if (!obj.isExtensible()) {
            throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
        }
        for (Scriptable prototypeProto = proto; prototypeProto != null; prototypeProto = prototypeProto.getPrototype()) {
            if (prototypeProto != obj) continue;
            throw ScriptRuntime.typeErrorById("msg.object.cyclic.prototype", obj.getClass().getSimpleName());
        }
        obj.setPrototype(proto);
        return obj;
    }

    private static Object js_keys(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable obj = NativeObject.getCompatibleObject(cx, scope, arg);
        Object[] ids = obj.getIds();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ScriptRuntime.toString(ids[i]);
        }
        return cx.newArray(scope, ids);
    }

    private static Object js_entries(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable obj = NativeObject.getCompatibleObject(cx, scope, arg);
        Object[] ids = obj.getIds();
        int j = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] instanceof Integer) {
                int intId = (Integer)ids[i];
                if (!obj.has(intId, obj) || !NativeObject.isEnumerable(intId, (Object)obj)) continue;
                String stringId = ScriptRuntime.toString(ids[i]);
                Object[] entry = new Object[]{stringId, obj.get(intId, obj)};
                ids[j++] = cx.newArray(scope, entry);
                continue;
            }
            String stringId = ScriptRuntime.toString(ids[i]);
            if (!obj.has(stringId, obj) || !NativeObject.isEnumerable(stringId, (Object)obj)) continue;
            Object[] entry = new Object[]{stringId, obj.get(stringId, obj)};
            ids[j++] = cx.newArray(scope, entry);
        }
        if (j != ids.length) {
            ids = Arrays.copyOf(ids, j);
        }
        return cx.newArray(scope, ids);
    }

    private static Object js_fromEntries(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        arg = NativeObject.getCompatibleObject(cx, scope, arg);
        Scriptable obj = cx.newObject(scope);
        ScriptRuntime.loadFromIterable(cx, scope, arg, (key, value) -> {
            if (key instanceof Integer) {
                obj.put((Integer)key, obj, value);
            } else if (key instanceof Symbol && obj instanceof SymbolScriptable) {
                ((SymbolScriptable)((Object)obj)).put((Symbol)key, obj, value);
            } else {
                obj.put(ScriptRuntime.toString(key), obj, value);
            }
        });
        return obj;
    }

    private static Object js_values(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable obj = NativeObject.getCompatibleObject(cx, scope, arg);
        Object[] ids = obj.getIds();
        int j = 0;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] instanceof Integer) {
                int intId = (Integer)ids[i];
                if (!obj.has(intId, obj) || !NativeObject.isEnumerable(intId, (Object)obj)) continue;
                ids[j++] = obj.get(intId, obj);
                continue;
            }
            String stringId = ScriptRuntime.toString(ids[i]);
            if (!obj.has(stringId, obj) || !NativeObject.isEnumerable(stringId, (Object)obj)) continue;
            ids[j++] = obj.get(stringId, obj);
        }
        if (j != ids.length) {
            ids = Arrays.copyOf(ids, j);
        }
        return cx.newArray(scope, ids);
    }

    private static Object js_hasOwn(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Object propertyName = args.length < 2 ? Undefined.instance : args[1];
        return AbstractEcmaObjectOperations.hasOwnProperty(cx, arg, propertyName);
    }

    private static Object js_getOwnPropertyNames(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable s = NativeObject.getCompatibleObject(cx, scope, arg);
        ScriptableObject obj = NativeObject.ensureScriptableObject(s);
        Object[] ids = obj.getIds(true, false);
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ScriptRuntime.toString(ids[i]);
        }
        return cx.newArray(scope, ids);
    }

    private static Object js_getOwnPropertySymbols(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable s = NativeObject.getCompatibleObject(cx, scope, arg);
        ScriptableObject obj = NativeObject.ensureScriptableObject(s);
        Object[] ids = obj.getIds(true, true);
        ArrayList<Object> syms = new ArrayList<Object>();
        for (Object o : ids) {
            if (!(o instanceof Symbol)) continue;
            syms.add(o);
        }
        return cx.newArray(scope, syms.toArray());
    }

    private static Object js_getOwnPropDesc(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable s = NativeObject.getCompatibleObject(cx, scope, arg);
        ScriptableObject obj = NativeObject.ensureScriptableObject(s);
        Object nameArg = args.length < 2 ? Undefined.instance : args[1];
        ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, nameArg);
        return desc == null ? Undefined.instance : desc;
    }

    private static Object js_getOwnPropDescs(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable s = NativeObject.getCompatibleObject(cx, scope, arg);
        ScriptableObject obj = NativeObject.ensureScriptableObject(s);
        ScriptableObject descs = (ScriptableObject)cx.newObject(scope);
        for (Object key : obj.getIds(true, true)) {
            ScriptableObject desc = obj.getOwnPropertyDescriptor(cx, key);
            if (desc == null) continue;
            if (key instanceof Symbol) {
                descs.put((Symbol)key, (Scriptable)descs, (Object)desc);
                continue;
            }
            if (key instanceof Integer) {
                descs.put((Integer)key, (Scriptable)descs, (Object)desc);
                continue;
            }
            descs.put(ScriptRuntime.toString(key), (Scriptable)descs, (Object)desc);
        }
        return descs;
    }

    private static Object js_defineProperty(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        ScriptableObject obj = NativeObject.ensureScriptableObject(arg);
        Object name = args.length < 2 ? Undefined.instance : args[1];
        Object descArg = args.length < 3 ? Undefined.instance : args[2];
        ScriptableObject desc = NativeObject.ensureScriptableObject(descArg);
        obj.defineOwnProperty(cx, name, desc);
        return obj;
    }

    private static Object js_isExtensible(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg;
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (!(arg instanceof ScriptableObject)) {
            return Boolean.FALSE;
        }
        ScriptableObject obj = NativeObject.ensureScriptableObject(arg);
        return obj.isExtensible();
    }

    private static Object js_preventExtensions(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg;
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (!(arg instanceof ScriptableObject)) {
            return arg;
        }
        ScriptableObject obj = NativeObject.ensureScriptableObject(arg);
        if (!obj.preventExtensions()) {
            throw ScriptRuntime.typeError("Object.preventExtensions is not allowed");
        }
        return obj;
    }

    private static Object js_defineProperties(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        ScriptableObject obj = NativeObject.ensureScriptableObject(arg);
        Object propsObj = args.length < 2 ? Undefined.instance : args[1];
        Scriptable props = Context.toObject(propsObj, scope);
        obj.defineOwnProperties(cx, NativeObject.ensureScriptableObject(props));
        return obj;
    }

    private static Object js_create(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg = args.length < 1 ? Undefined.instance : args[0];
        Scriptable obj = arg == null ? null : NativeObject.ensureScriptable(arg);
        NativeObject newObject = new NativeObject();
        newObject.setParentScope(scope);
        newObject.setPrototype(obj);
        if (args.length > 1 && !Undefined.isUndefined(args[1])) {
            Scriptable props = Context.toObject(args[1], scope);
            newObject.defineOwnProperties(cx, NativeObject.ensureScriptableObject(props));
        }
        return newObject;
    }

    private static Object js_isSealed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg;
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (!(arg instanceof ScriptableObject)) {
            return Boolean.TRUE;
        }
        return AbstractEcmaObjectOperations.testIntegrityLevel(cx, arg, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.SEALED);
    }

    private static Object js_isFrozen(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg;
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (!(arg instanceof ScriptableObject)) {
            return Boolean.TRUE;
        }
        return AbstractEcmaObjectOperations.testIntegrityLevel(cx, arg, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.FROZEN);
    }

    private static Object js_seal(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg;
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (!(arg instanceof ScriptableObject)) {
            return arg;
        }
        boolean status = AbstractEcmaObjectOperations.setIntegrityLevel(cx, arg, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.SEALED);
        if (!status) {
            throw ScriptRuntime.typeError("Object is not sealable");
        }
        return arg;
    }

    private static Object js_freeze(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg;
        Object object = arg = args.length < 1 ? Undefined.instance : args[0];
        if (!(arg instanceof ScriptableObject)) {
            return arg;
        }
        boolean status = AbstractEcmaObjectOperations.setIntegrityLevel(cx, arg, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.FROZEN);
        if (!status) {
            throw ScriptRuntime.typeError("Object is not freezable");
        }
        return arg;
    }

    private static Object js_assign(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Scriptable targetObj = args.length > 0 ? ScriptRuntime.toObject(cx, scope, args[0]) : ScriptRuntime.toObject(cx, scope, Undefined.instance);
        for (int i = 1; i < args.length; ++i) {
            Object[] ids;
            if (args[i] == null || Undefined.isUndefined(args[i])) continue;
            Scriptable sourceObj = ScriptRuntime.toObject(cx, scope, args[i]);
            for (Object key : ids = sourceObj.getIds()) {
                Object val;
                if (key instanceof Integer) {
                    int intId = (Integer)key;
                    if (!sourceObj.has(intId, sourceObj) || !NativeObject.isEnumerable(intId, (Object)sourceObj)) continue;
                    val = sourceObj.get(intId, sourceObj);
                    AbstractEcmaObjectOperations.put(cx, targetObj, intId, val, true);
                    continue;
                }
                String stringId = ScriptRuntime.toString(key);
                if (!sourceObj.has(stringId, sourceObj) || !NativeObject.isEnumerable(stringId, (Object)sourceObj)) continue;
                val = sourceObj.get(stringId, sourceObj);
                AbstractEcmaObjectOperations.put(cx, targetObj, stringId, val, true);
            }
        }
        return targetObj;
    }

    private static Object js_is(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object a1 = args.length < 1 ? Undefined.instance : args[0];
        Object a2 = args.length < 2 ? Undefined.instance : args[1];
        return ScriptRuntime.wrapBoolean(ScriptRuntime.same(a1, a2));
    }

    private static Object js_groupBy(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object items = args.length < 1 ? Undefined.instance : args[0];
        Object callback = args.length < 2 ? Undefined.instance : args[1];
        Map<Object, List<Object>> groups = AbstractEcmaObjectOperations.groupBy(cx, scope, OBJECT_TAG, "groupBy", items, callback, AbstractEcmaObjectOperations.KEY_COERCION.PROPERTY);
        NativeObject obj = (NativeObject)cx.newObject(scope);
        obj.setPrototype(null);
        for (Map.Entry<Object, List<Object>> entry : groups.entrySet()) {
            Scriptable elements = cx.newArray(scope, entry.getValue().toArray());
            ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
            desc.put("enumerable", (Scriptable)desc, (Object)Boolean.TRUE);
            desc.put("configurable", (Scriptable)desc, (Object)Boolean.TRUE);
            desc.put("value", (Scriptable)desc, (Object)elements);
            obj.defineOwnProperty(cx, entry.getKey(), desc);
        }
        return obj;
    }

    private static boolean isEnumerable(int index, Object obj) {
        if (obj instanceof ScriptableObject) {
            ScriptableObject so = (ScriptableObject)obj;
            try {
                int attrs = so.getAttributes(index);
                return (attrs & 2) == 0;
            }
            catch (RhinoException re) {
                return true;
            }
        }
        return true;
    }

    private static boolean isEnumerable(String key, Object obj) {
        if (obj instanceof ScriptableObject) {
            ScriptableObject so = (ScriptableObject)obj;
            try {
                int attrs = so.getAttributes(key);
                return (attrs & 2) == 0;
            }
            catch (RhinoException re) {
                return true;
            }
        }
        return true;
    }

    private static boolean isEnumerable(Symbol sym, Object obj) {
        if (obj instanceof ScriptableObject) {
            ScriptableObject so = (ScriptableObject)obj;
            try {
                int attrs = so.getAttributes(sym);
                return (attrs & 2) == 0;
            }
            catch (RhinoException re) {
                return true;
            }
        }
        return true;
    }

    private static Scriptable getCompatibleObject(Context cx, Scriptable scope, Object arg) {
        Scriptable s = ScriptRuntime.toObject(cx, scope, arg);
        return NativeObject.ensureScriptable(s);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.has((String)key, (Scriptable)this);
        }
        if (key instanceof Number) {
            return this.has(((Number)key).intValue(), (Scriptable)this);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object obj : this.values()) {
            if (!Objects.equals(value, obj)) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object key) {
        Object value = this.get(key);
        if (key instanceof String) {
            this.delete((String)key);
        } else if (key instanceof Number) {
            this.delete(((Number)key).intValue());
        }
        return value;
    }

    public Set<Object> keySet() {
        return new KeySet();
    }

    public Collection<Object> values() {
        return new ValueCollection();
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return new EntrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    class ValueCollection
    extends AbstractCollection<Object> {
        ValueCollection() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Object next() {
                    this.key = this.ids[this.index++];
                    return NativeObject.this.get(this.key);
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }

    class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public boolean contains(Object key) {
            return NativeObject.this.containsKey(key);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Object next() {
                    try {
                        this.key = this.ids[this.index++];
                        return this.key;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.key = null;
                        throw new NoSuchElementException();
                    }
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new Iterator<Map.Entry<Object, Object>>(){
                Object[] ids;
                Object key;
                int index;
                {
                    this.ids = NativeObject.this.getIds();
                    this.key = null;
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.ids.length;
                }

                @Override
                public Map.Entry<Object, Object> next() {
                    final Object ekey = this.key = this.ids[this.index++];
                    final Object value = NativeObject.this.get(this.key);
                    return new Map.Entry<Object, Object>(){

                        @Override
                        public Object getKey() {
                            return ekey;
                        }

                        @Override
                        public Object getValue() {
                            return value;
                        }

                        @Override
                        public Object setValue(Object value2) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean equals(Object other) {
                            if (!(other instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry e = (Map.Entry)other;
                            return (ekey == null ? e.getKey() == null : ekey.equals(e.getKey())) && (value == null ? e.getValue() == null : value.equals(e.getValue()));
                        }

                        @Override
                        public int hashCode() {
                            return (ekey == null ? 0 : ekey.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        public String toString() {
                            return ekey + "=" + value;
                        }
                    };
                }

                @Override
                public void remove() {
                    if (this.key == null) {
                        throw new IllegalStateException();
                    }
                    NativeObject.this.remove(this.key);
                    this.key = null;
                }
            };
        }

        @Override
        public int size() {
            return NativeObject.this.size();
        }
    }
}

