/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.i18n;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CompositeMessageSource
implements MessageSource {
    private final List<MessageSource> messageSources = new CopyOnWriteArrayList<MessageSource>();

    public void addMessageSources(Collection<MessageSource> source) {
        this.messageSources.addAll(source);
    }

    public void addMessageSource(MessageSource source) {
        this.messageSources.add(source);
    }

    public String getMessage(@Nonnull String code, Object[] args, String defaultMessage, @Nonnull Locale locale) {
        for (MessageSource messageSource : this.messageSources) {
            String result = messageSource.getMessage(code, args, null, locale);
            if (!StringUtils.hasText((String)result)) continue;
            return result;
        }
        return defaultMessage;
    }

    @Nonnull
    public String getMessage(@Nonnull String code, Object[] args, @Nonnull Locale locale) throws NoSuchMessageException {
        for (MessageSource messageSource : this.messageSources) {
            try {
                String result = messageSource.getMessage(code, args, locale);
                if (!StringUtils.hasText((String)result)) continue;
                return result;
            }
            catch (NoSuchMessageException noSuchMessageException) {
            }
        }
        throw new NoSuchMessageException(code, locale);
    }

    @Nonnull
    public String getMessage(@Nonnull MessageSourceResolvable resolvable, @Nonnull Locale locale) throws NoSuchMessageException {
        for (MessageSource messageSource : this.messageSources) {
            try {
                String result = messageSource.getMessage(resolvable, locale);
                if (!StringUtils.hasText((String)result)) continue;
                return result;
            }
            catch (NoSuchMessageException noSuchMessageException) {
            }
        }
        Object[] codes = resolvable.getCodes();
        throw new NoSuchMessageException((String)(!ObjectUtils.isEmpty((Object[])codes) ? codes[codes.length - 1] : ""), locale);
    }
}

