/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import org.hswebframework.web.datasource.AopDataSourceSwitcherAutoConfiguration;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.DynamicDataSourceService;
import org.hswebframework.web.datasource.HswebDataSourceProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ImportAutoConfiguration(value={AopDataSourceSwitcherAutoConfiguration.class})
public class DynamicDataSourceAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.datasource")
    public HswebDataSourceProperties hswebDataSouceProperties() {
        return new HswebDataSourceProperties();
    }

    @Bean
    public BeanPostProcessor switcherInitProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DynamicDataSourceService) {
                    DataSourceHolder.dynamicDataSourceService = (DynamicDataSourceService)bean;
                }
                return bean;
            }
        };
    }
}

