/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hswebframework.web.authorization.basic.aop.AopMethodAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenForTypeParser;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenHolder;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebUserTokenInterceptor
implements HandlerInterceptor {
    static final String TOKEN_ATTR = WebUserTokenInterceptor.class.getName() + ".token";
    private final UserTokenManager userTokenManager;
    private final List<UserTokenParser> userTokenParser;
    private final AopMethodAuthorizeDefinitionParser parser;
    private final boolean enableBasicAuthorization;

    public WebUserTokenInterceptor(UserTokenManager userTokenManager, List<UserTokenParser> userTokenParser, AopMethodAuthorizeDefinitionParser definitionParser) {
        this.userTokenManager = userTokenManager;
        this.userTokenParser = userTokenParser;
        this.parser = definitionParser;
        this.enableBasicAuthorization = userTokenParser.stream().filter(UserTokenForTypeParser.class::isInstance).anyMatch(parser -> "basic".equalsIgnoreCase(((UserTokenForTypeParser)parser).getTokenType()));
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        List<ParsedToken> tokens = this.userTokenParser.stream().map(parser -> parser.parseToken(request)).filter(Objects::nonNull).toList();
        if (tokens.isEmpty()) {
            HandlerMethod method;
            AuthorizeDefinition definition;
            if (this.enableBasicAuthorization && handler instanceof HandlerMethod && null != (definition = this.parser.parse((method = (HandlerMethod)handler).getBeanType(), method.getMethod()))) {
                response.addHeader("WWW-Authenticate", " Basic realm=\"\"");
            }
            return true;
        }
        for (ParsedToken parsedToken : tokens) {
            UserToken userToken = null;
            String token = parsedToken.getToken();
            if (this.userTokenManager.tokenIsLoggedIn(token).blockOptional().orElse(false).booleanValue()) {
                userToken = this.userTokenManager.getByToken(token).blockOptional().orElse(null);
            }
            if ((userToken == null || userToken.isExpired()) && parsedToken instanceof AuthorizedToken) {
                userToken = (UserToken)this.userTokenManager.signOutByToken(token).then(this.userTokenManager.signIn(parsedToken.getToken(), parsedToken.getType(), ((AuthorizedToken)parsedToken).getUserId(), ((AuthorizedToken)parsedToken).getMaxInactiveInterval())).block();
            }
            if (null == userToken) continue;
            this.userTokenManager.touch(token).subscribe();
            request.setAttribute(TOKEN_ATTR, (Object)UserTokenHolder.makeCurrent((UserToken)userToken));
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler, Exception ex) throws Exception {
        Object closable = request.getAttribute(TOKEN_ATTR);
        if (closable instanceof Closeable) {
            Closeable c = (Closeable)closable;
            c.close();
        }
    }
}

