/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.hswebframework.web.authorization.basic.web.AuthorizedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionIdUserTokenParser
implements UserTokenParser {
    protected UserTokenManager userTokenManager;

    @Autowired
    public void setUserTokenManager(UserTokenManager userTokenManager) {
        this.userTokenManager = userTokenManager;
    }

    @Override
    public ParsedToken parseToken(HttpServletRequest request) {
        final HttpSession session = request.getSession(false);
        if (session != null) {
            final String sessionId = session.getId();
            UserToken token = (UserToken)this.userTokenManager.getByToken(sessionId).block();
            final long interval = session.getMaxInactiveInterval();
            if (token != null && token.isExpired()) {
                final String userId = token.getUserId();
                return new AuthorizedToken(){

                    @Override
                    public String getUserId() {
                        return userId;
                    }

                    public String getToken() {
                        return sessionId;
                    }

                    public String getType() {
                        return "sessionId";
                    }

                    @Override
                    public long getMaxInactiveInterval() {
                        return interval;
                    }
                };
            }
            return new ParsedToken(){

                public String getToken() {
                    return session.getId();
                }

                public String getType() {
                    return "sessionId";
                }
            };
        }
        return null;
    }
}

