/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.basic.web.GeneratedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenGenerator;
import org.hswebframework.web.utils.WebUtils;

public class SessionIdUserTokenGenerator
implements UserTokenGenerator,
Serializable {
    private static final long serialVersionUID = -9197243220777237431L;

    @Override
    public String getSupportTokenType() {
        return "sessionId";
    }

    @Override
    public GeneratedToken generate(Authentication authentication) {
        HttpServletRequest request = WebUtils.getHttpServletRequest();
        if (null == request) {
            throw new UnsupportedOperationException();
        }
        final int timeout = request.getSession().getMaxInactiveInterval() * 1000;
        final String sessionId = request.getSession().getId();
        return new GeneratedToken(){
            private static final long serialVersionUID = 3964183451883410929L;

            @Override
            public Map<String, Object> getResponse() {
                return new HashMap<String, Object>();
            }

            @Override
            public String getToken() {
                return sessionId;
            }

            @Override
            public String getType() {
                return "sessionId";
            }

            @Override
            public long getTimeout() {
                return timeout;
            }
        };
    }
}

