/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.basic.web.GeneratedToken;
import org.hswebframework.web.authorization.basic.web.UserTokenGenerator;
import org.hswebframework.web.authorization.basic.web.UserTokenParser;
import org.hswebframework.web.authorization.token.ParsedToken;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.util.StringUtils;

public class ServletUserTokenGenPar
implements UserTokenParser,
UserTokenGenerator {
    private long timeout = TimeUnit.MINUTES.toMillis(30L);
    private String headerName = "X-Access-Token";

    @Override
    public String getSupportTokenType() {
        return "default";
    }

    @Override
    public GeneratedToken generate(Authentication authentication) {
        final String token = (String)IDGenerator.MD5.generate();
        return new GeneratedToken(){

            @Override
            public Map<String, Object> getResponse() {
                return Collections.singletonMap("expires", ServletUserTokenGenPar.this.timeout);
            }

            @Override
            public String getToken() {
                return token;
            }

            @Override
            public String getType() {
                return ServletUserTokenGenPar.this.getSupportTokenType();
            }

            @Override
            public long getTimeout() {
                return ServletUserTokenGenPar.this.timeout;
            }
        };
    }

    @Override
    public ParsedToken parseToken(HttpServletRequest request) {
        String token = Optional.ofNullable(request.getHeader(this.headerName)).orElseGet(() -> request.getParameter(":X_Access_Token"));
        if (StringUtils.hasText((String)token)) {
            return ParsedToken.of((String)this.getSupportTokenType(), (String)token);
        }
        return null;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getHeaderName() {
        return this.headerName;
    }

    @Generated
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

