/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler;

import java.util.Set;
import lombok.Generated;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.access.DataAccessController;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.authorization.basic.handler.AuthorizingHandler;
import org.hswebframework.web.authorization.define.AuthorizeDefinition;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.DimensionsDefinition;
import org.hswebframework.web.authorization.define.HandleType;
import org.hswebframework.web.authorization.define.ResourcesDefinition;
import org.hswebframework.web.authorization.events.AuthorizingHandleBeforeEvent;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Mono;

public class DefaultAuthorizingHandler
implements AuthorizingHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthorizingHandler.class);
    private DataAccessController dataAccessController;
    private ApplicationEventPublisher eventPublisher;

    public DefaultAuthorizingHandler(DataAccessController dataAccessController) {
        this.dataAccessController = dataAccessController;
    }

    public DefaultAuthorizingHandler() {
    }

    public void setDataAccessController(DataAccessController dataAccessController) {
        this.dataAccessController = dataAccessController;
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handRBAC(AuthorizingContext context) {
        if (this.handleEvent(context, HandleType.RBAC)) {
            return;
        }
        this.handleRBAC(context.getAuthentication(), context.getDefinition());
    }

    @Override
    public Mono<Void> handRBACAsync(AuthorizingContext context) {
        return this.handleEventAsync(context, HandleType.RBAC).doOnNext(handled -> {
            if (!handled.booleanValue()) {
                this.handleRBAC(context.getAuthentication(), context.getDefinition());
            }
        }).then();
    }

    private Mono<Boolean> handleEventAsync(AuthorizingContext context, HandleType type) {
        if (null != this.eventPublisher) {
            AuthorizingHandleBeforeEvent event = new AuthorizingHandleBeforeEvent(context, type);
            return event.publish(this.eventPublisher).then(Mono.fromCallable(() -> {
                if (!event.isExecute()) {
                    if (event.isAllow()) {
                        return true;
                    }
                    throw new AccessDenyException.NoStackTrace(event.getMessage());
                }
                return false;
            }));
        }
        return Mono.just((Object)false);
    }

    private boolean handleEvent(AuthorizingContext context, HandleType type) {
        if (null != this.eventPublisher) {
            AuthorizingHandleBeforeEvent event = new AuthorizingHandleBeforeEvent(context, type);
            this.eventPublisher.publishEvent((Object)event);
            if (event.hasListener()) {
                event.getAsync().block();
            }
            if (!event.isExecute()) {
                if (event.isAllow()) {
                    return true;
                }
                throw new AccessDenyException.NoStackTrace(event.getMessage());
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public void handleDataAccess(AuthorizingContext context) {
    }

    protected void handleRBAC(Authentication authentication, AuthorizeDefinition definition) {
        ResourcesDefinition resources = definition.getResources();
        if (!resources.hasPermission(authentication)) {
            throw new AccessDenyException.NoStackTrace(definition.getMessage(), definition.getDescription());
        }
        DimensionsDefinition dd = definition.getDimensions();
        if (dd != null && !dd.isEmpty() && !dd.hasDimension((type, logical, dimensionIds) -> this.hasDimensions(authentication, (String)type, (Logical)logical, (Set<String>)dimensionIds))) {
            throw new AccessDenyException.NoStackTrace(definition.getMessage(), definition.getDimensions().toString());
        }
    }

    private boolean hasDimensions(Authentication auth, String type, Logical logical, Set<String> dimensionIds) {
        if (logical == Logical.AND) {
            return auth.hasAllDimension(type, dimensionIds);
        }
        return auth.hasAnyDimension(type, dimensionIds);
    }
}

