/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.embed;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.AuthenticationRequest;
import org.hswebframework.web.authorization.basic.embed.EmbedAuthenticationInfo;
import org.hswebframework.web.authorization.builder.DataAccessConfigBuilderFactory;
import org.hswebframework.web.authorization.simple.PlainTextUsernamePasswordAuthenticationRequest;
import org.hswebframework.web.authorization.simple.builder.SimpleDataAccessConfigBuilderFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.ObjectUtils;

@ConfigurationProperties(prefix="hsweb.auth")
public class EmbedAuthenticationProperties
implements InitializingBean {
    private Map<String, Authentication> authentications = new HashMap<String, Authentication>();
    private Map<String, EmbedAuthenticationInfo> users = new HashMap<String, EmbedAuthenticationInfo>();
    @Autowired(required=false)
    private DataAccessConfigBuilderFactory dataAccessConfigBuilderFactory = new SimpleDataAccessConfigBuilderFactory();

    public void afterPropertiesSet() {
        this.users.forEach((id, properties) -> {
            if (ObjectUtils.isEmpty((Object)properties.getId())) {
                properties.setId((String)id);
            }
            this.authentications.put((String)id, properties.toAuthentication(this.dataAccessConfigBuilderFactory));
        });
    }

    public Authentication authenticate(AuthenticationRequest request) {
        if (MapUtils.isEmpty(this.users)) {
            return null;
        }
        if (request instanceof PlainTextUsernamePasswordAuthenticationRequest) {
            PlainTextUsernamePasswordAuthenticationRequest pwdReq = (PlainTextUsernamePasswordAuthenticationRequest)request;
            for (EmbedAuthenticationInfo user : this.users.values()) {
                if (!pwdReq.getUsername().equals(user.getUsername())) continue;
                if (pwdReq.getPassword().equals(user.getPassword())) {
                    return user.toAuthentication(this.dataAccessConfigBuilderFactory);
                }
                return null;
            }
            return null;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6388\u6743\u8bf7\u6c42:" + request);
    }

    public Optional<Authentication> getAuthentication(String userId) {
        return Optional.ofNullable(this.authentications.get(userId));
    }

    @Generated
    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    @Generated
    public DataAccessConfigBuilderFactory getDataAccessConfigBuilderFactory() {
        return this.dataAccessConfigBuilderFactory;
    }

    @Generated
    public void setAuthentications(Map<String, Authentication> authentications) {
        this.authentications = authentications;
    }

    @Generated
    public void setDataAccessConfigBuilderFactory(DataAccessConfigBuilderFactory dataAccessConfigBuilderFactory) {
        this.dataAccessConfigBuilderFactory = dataAccessConfigBuilderFactory;
    }

    @Generated
    public Map<String, EmbedAuthenticationInfo> getUsers() {
        return this.users;
    }

    @Generated
    public void setUsers(Map<String, EmbedAuthenticationInfo> users) {
        this.users = users;
    }
}

