/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.define;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import lombok.Generated;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DataAccessType;
import org.hswebframework.web.authorization.annotation.Dimension;
import org.hswebframework.web.authorization.annotation.Dimensions;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.basic.define.AopAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.DataAccessTypeDefinition;
import org.hswebframework.web.authorization.define.DimensionDefinition;
import org.hswebframework.web.authorization.define.DimensionsDefinition;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;
import org.hswebframework.web.authorization.define.ResourcesDefinition;

public class DefaultBasicAuthorizeDefinition
implements AopAuthorizeDefinition {
    @JsonIgnore
    private Class<?> targetClass;
    @JsonIgnore
    private Method targetMethod;
    private ResourcesDefinition resources = new ResourcesDefinition();
    private DimensionsDefinition dimensions = new DimensionsDefinition();
    private String message = "error.access_denied";
    private Phased phased = Phased.before;
    private boolean allowAnonymous = false;

    public boolean isEmpty() {
        return false;
    }

    public boolean allowAnonymous() {
        return this.allowAnonymous;
    }

    public static AopAuthorizeDefinition from(Class<?> targetClass, Method method) {
        AopAuthorizeDefinitionParser parser = new AopAuthorizeDefinitionParser(targetClass, method);
        return parser.parse();
    }

    public void putAnnotation(Dimensions ann) {
        this.dimensions.setLogical(ann.logical());
        if (ann.description().length > 0) {
            this.dimensions.setDescription(String.join((CharSequence)"", ann.description()));
        }
    }

    public void putAnnotation(Authorize ann) {
        if (!ann.merge()) {
            this.getResources().clear();
            this.getDimensions().clear();
        }
        this.setPhased(ann.phased());
        this.getResources().setPhased(ann.phased());
        for (Resource resource : ann.resources()) {
            this.putAnnotation(resource);
        }
        for (Resource resource : ann.dimension()) {
            this.putAnnotation((Dimension)resource);
        }
        if (ann.anonymous()) {
            this.allowAnonymous = true;
        }
    }

    public void putAnnotation(Dimension ann) {
        if (ann.ignore()) {
            this.getDimensions().clear();
            return;
        }
        DimensionDefinition definition = new DimensionDefinition();
        definition.setTypeId(ann.type());
        definition.setDimensionId(new HashSet<String>(Arrays.asList(ann.id())));
        definition.setLogical(ann.logical());
        this.getDimensions().addDimension(definition);
    }

    public void putAnnotation(Resource ann) {
        ResourceDefinition resource = new ResourceDefinition();
        resource.setId(ann.id());
        resource.setName(ann.name());
        resource.setLogical(ann.logical());
        resource.setPhased(ann.phased());
        resource.setDescription(String.join((CharSequence)"\n", ann.description()));
        for (ResourceAction action : ann.actions()) {
            this.putAnnotation(resource, action);
        }
        resource.setGroup(new ArrayList<String>(Arrays.asList(ann.group())));
        this.setPhased(ann.phased());
        this.getResources().setPhased(ann.phased());
        this.resources.addResource(resource, ann.merge());
    }

    public ResourceActionDefinition putAnnotation(ResourceDefinition definition, ResourceAction ann) {
        ResourceActionDefinition actionDefinition = new ResourceActionDefinition();
        actionDefinition.setId(ann.id());
        actionDefinition.setName(ann.name());
        actionDefinition.setDescription(String.join((CharSequence)"\n", ann.description()));
        definition.addAction(actionDefinition);
        return actionDefinition;
    }

    public void putAnnotation(ResourceActionDefinition definition, DataAccessType dataAccessType) {
        if (dataAccessType.ignore()) {
            return;
        }
        DataAccessTypeDefinition typeDefinition = new DataAccessTypeDefinition();
        typeDefinition.setId(dataAccessType.id());
        typeDefinition.setName(dataAccessType.name());
        typeDefinition.setController(dataAccessType.controller());
        typeDefinition.setConfiguration(dataAccessType.configuration());
        typeDefinition.setDescription(String.join((CharSequence)"\n", dataAccessType.description()));
        definition.getDataAccess().getDataAccessTypes().add(typeDefinition);
    }

    @Generated
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Generated
    public Method getTargetMethod() {
        return this.targetMethod;
    }

    @Generated
    public ResourcesDefinition getResources() {
        return this.resources;
    }

    @Generated
    public DimensionsDefinition getDimensions() {
        return this.dimensions;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Phased getPhased() {
        return this.phased;
    }

    @Generated
    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    @Generated
    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Generated
    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    @Generated
    public void setResources(ResourcesDefinition resources) {
        this.resources = resources;
    }

    @Generated
    public void setDimensions(DimensionsDefinition dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setPhased(Phased phased) {
        this.phased = phased;
    }

    @Generated
    public void setAllowAnonymous(boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    @Generated
    public DefaultBasicAuthorizeDefinition() {
    }

    @Generated
    public DefaultBasicAuthorizeDefinition(Class<?> targetClass, Method targetMethod, ResourcesDefinition resources, DimensionsDefinition dimensions, String message, Phased phased, boolean allowAnonymous) {
        this.targetClass = targetClass;
        this.targetMethod = targetMethod;
        this.resources = resources;
        this.dimensions = dimensions;
        this.message = message;
        this.phased = phased;
        this.allowAnonymous = allowAnonymous;
    }

    @Generated
    public String toString() {
        return "DefaultBasicAuthorizeDefinition(targetClass=" + this.getTargetClass() + ", targetMethod=" + this.getTargetMethod() + ", resources=" + this.getResources() + ", dimensions=" + this.getDimensions() + ", message=" + this.getMessage() + ", phased=" + this.getPhased() + ", allowAnonymous=" + this.isAllowAnonymous() + ")";
    }
}

