/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.define;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Dimension;
import org.hswebframework.web.authorization.annotation.Dimensions;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.basic.define.DefaultBasicAuthorizeDefinition;
import org.hswebframework.web.authorization.basic.define.EmptyAuthorizeDefinition;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;

public class AopAuthorizeDefinitionParser {
    private static final Set<Class<? extends Annotation>> types = new HashSet<Class>(Arrays.asList(Authorize.class, Dimension.class, Resource.class, ResourceAction.class, Dimensions.class));
    private final Set<Annotation> methodAnnotation;
    private final Set<Annotation> classAnnotation;
    private final Map<Class<? extends Annotation>, List<Annotation>> classAnnotationGroup;
    private final Map<Class<? extends Annotation>, List<Annotation>> methodAnnotationGroup;
    private final DefaultBasicAuthorizeDefinition definition = new DefaultBasicAuthorizeDefinition();

    AopAuthorizeDefinitionParser(Class<?> targetClass, Method method) {
        this.definition.setTargetClass(targetClass);
        this.definition.setTargetMethod(method);
        this.methodAnnotation = this.loadAnnotations(method);
        this.classAnnotation = this.loadAnnotations(targetClass);
        this.classAnnotationGroup = this.classAnnotation.stream().collect(Collectors.groupingBy(Annotation::annotationType));
        this.methodAnnotationGroup = this.methodAnnotation.stream().collect(Collectors.groupingBy(Annotation::annotationType));
    }

    private Set<Annotation> loadAnnotations(AnnotatedElement element) {
        return types.stream().flatMap(s -> {
            if (s.isAnnotationPresent(Repeatable.class)) {
                return AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)element, (Class)s).stream();
            }
            return AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)element, (Class)s).stream();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void initClassAnnotation() {
        for (Annotation annotation : this.classAnnotation) {
            if (annotation instanceof Authorize) {
                this.definition.putAnnotation((Authorize)annotation);
            }
            if (!(annotation instanceof Resource)) continue;
            this.definition.putAnnotation((Resource)annotation);
        }
    }

    private void initMethodAnnotation() {
        for (Annotation annotation : this.methodAnnotation) {
            if (annotation instanceof Authorize) {
                this.definition.putAnnotation((Authorize)annotation);
            }
            if (annotation instanceof Resource) {
                this.definition.putAnnotation((Resource)annotation);
            }
            if (annotation instanceof Dimension) {
                this.definition.putAnnotation((Dimension)annotation);
            }
            if (annotation instanceof Dimensions) {
                this.definition.putAnnotation((Dimensions)annotation);
            }
            if (!(annotation instanceof ResourceAction)) continue;
            this.getAnnotationByType(Resource.class).map(res -> this.definition.getResources().getResource(res.id()).orElse(null)).filter(Objects::nonNull).forEach(res -> this.definition.putAnnotation((ResourceDefinition)res, (ResourceAction)annotation));
        }
    }

    AopAuthorizeDefinition parse() {
        if (CollectionUtils.isEmpty(this.classAnnotation) && CollectionUtils.isEmpty(this.methodAnnotation)) {
            return EmptyAuthorizeDefinition.instance;
        }
        this.initClassAnnotation();
        this.initMethodAnnotation();
        return this.definition;
    }

    private <T extends Annotation> Stream<T> getAnnotationByType(Class<T> type) {
        return Optional.ofNullable(this.methodAnnotationGroup.getOrDefault(type, this.classAnnotationGroup.get(type))).stream().flatMap(Collection::stream).map(type::cast);
    }
}

