/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Serializable;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.Type;

public final class OtherType
extends Type {
    static final OtherType otherType = new OtherType();

    private OtherType() {
        super(1111, 1111, 0L, 0);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    public Class getJDBCClass() {
        return Object.class;
    }

    public String getJDBCClassName() {
        return "java.lang.Object";
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public int typeCode() {
        return this.typeCode;
    }

    public String getNameString() {
        return "OTHER";
    }

    public String getDefinition() {
        return "OTHER";
    }

    public Type getAggregateType(Type type) {
        if (this.typeCode == type.typeCode) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        throw Error.error(5562);
    }

    public Type getCombinedType(Type type, int n) {
        return this;
    }

    public int compare(Session session, Object object, Object object2) {
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return 0;
    }

    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return object;
    }

    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        return object;
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object instanceof Serializable) {
            return object;
        }
        throw Error.error(5561);
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return StringConverter.byteArrayToHexString(((JavaObjectData)object).getBytes());
    }

    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLHexString(((JavaObjectData)object).getBytes());
    }

    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        return ((JavaObjectData)object).getObject();
    }

    public boolean canConvertFrom(Type type) {
        if (type.typeCode == this.typeCode) {
            return true;
        }
        return type.typeCode == 0;
    }

    public boolean isObjectType() {
        return true;
    }

    public static OtherType getOtherType() {
        return otherType;
    }
}

