/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.server.Server;
import org.hsqldb.server.ServerConfiguration;
import org.hsqldb.server.ServerProperties;

public class WebServer
extends Server {
    static int webBundleHandle = BundleHandler.getBundleHandle("webserver", null);

    public WebServer() {
        super(0);
    }

    public static void main(String[] stringArray) {
        String string = FileUtil.getFileUtil().canonicalOrAbsolutePath("webserver");
        ServerProperties serverProperties = ServerConfiguration.getPropertiesFromFile(0, string);
        ServerProperties serverProperties2 = serverProperties == null ? new ServerProperties(0) : serverProperties;
        HsqlProperties hsqlProperties = null;
        hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        if (hsqlProperties.getErrorKeys().length != 0) {
            WebServer.printHelp("webserver.help");
            return;
        }
        serverProperties2.addProperties(hsqlProperties);
        ServerConfiguration.translateDefaultDatabaseProperty(serverProperties2);
        ServerConfiguration.translateDefaultNoSystemExitProperty(serverProperties2);
        WebServer webServer = new WebServer();
        try {
            webServer.setProperties(serverProperties2);
            serverProperties2.validate();
        }
        catch (Exception exception) {
            webServer.printError("Failed to set properties");
            webServer.printStackTrace(exception);
            return;
        }
        webServer.print("Startup sequence initiated from main() method");
        if (serverProperties != null) {
            webServer.print("Loaded properties from [" + string + ".properties]");
        } else {
            webServer.print("Could not load properties from file");
            webServer.print("Using cli/default properties only");
        }
        webServer.start();
    }

    public String getDefaultWebPage() {
        return this.serverProperties.getProperty("server.default_page");
    }

    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "webserver.help");
    }

    public String getProductName() {
        return "HSQLDB web server";
    }

    public String getProtocol() {
        return this.isTls() ? "HTTPS" : "HTTP";
    }

    public String getWebRoot() {
        return this.serverProperties.getProperty("server.root");
    }
}

