/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptReaderDecode
extends ScriptReaderText {
    DataInputStream dataInput;
    Crypto crypto;
    byte[] buffer = new byte[256];

    public ScriptReaderDecode(Database database, String string, Crypto crypto) throws IOException {
        super(database);
        InputStream inputStream = this.database.logger.getFileAccess().openInputStreamElement(string);
        InputStream inputStream2 = crypto.getInputStream(inputStream);
        inputStream2 = new GZIPInputStream(inputStream2);
        this.dataStreamIn = new BufferedReader(new InputStreamReader(inputStream2));
        this.rowIn = new RowInputTextLog();
    }

    public ScriptReaderDecode(Database database, String string, Crypto crypto, boolean bl) throws IOException {
        super(database);
        this.crypto = crypto;
        InputStream inputStream = this.database.logger.getFileAccess().openInputStreamElement(string);
        this.dataInput = new DataInputStream(new BufferedInputStream(inputStream));
        this.rowIn = new RowInputTextLog();
    }

    public boolean readLoggedStatement(Session session) throws IOException {
        int n;
        if (this.dataInput == null) {
            return super.readLoggedStatement(session);
        }
        try {
            n = this.dataInput.readInt();
            if (n * 2 > this.buffer.length) {
                this.buffer = new byte[n * 2];
            }
            this.dataInput.readFully(this.buffer, 0, n);
        }
        catch (Throwable throwable) {
            return false;
        }
        n = this.crypto.decode(this.buffer, 0, n, this.buffer, 0);
        String string = new String(this.buffer, 0, n, "ISO-8859-1");
        ++this.lineCount;
        this.statement = StringConverter.unicodeStringToString(string);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

