/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;

public final class CountdownInputStream
extends InputStream {
    private long count;
    private InputStream input;

    public CountdownInputStream(InputStream inputStream) {
        this.input = inputStream;
    }

    public int read() throws IOException {
        if (this.count <= 0L) {
            return -1;
        }
        int n = this.input.read();
        if (n >= 0) {
            --this.count;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.count <= 0L) {
            return -1;
        }
        int n2 = byArray.length;
        if ((long)n2 > this.count) {
            n2 = (int)this.count;
        }
        if ((n = this.input.read(byArray, 0, n2)) > 0) {
            this.count -= (long)n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.count <= 0L) {
            return -1;
        }
        if ((long)n2 > this.count) {
            n2 = (int)this.count;
        }
        if ((n3 = this.input.read(byArray, n, n2)) > 0) {
            this.count -= (long)n3;
        }
        return n3;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long l) {
        this.count = l;
    }
}

