/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hsqldb.FunctionCustom;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.types.Type;

public class JDBCDatabaseMetaData
implements DatabaseMetaData {
    static final Integer INT_COLUMNS_NO_NULLS = new Integer(0);
    private JDBCConnection connection;
    private final boolean useSchemaDefault;
    private static final String BRI_SESSION_SCOPE_IN_LIST = "(2)";
    private static final String BRI_TEMPORARY_SCOPE_IN_LIST = "(0,1,2)";
    private static final String BRI_TRANSACTION_SCOPE_IN_LIST = "(1,2)";
    private static final String selstar = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String whereTrue = " WHERE TRUE";
    public static final int JDBC_MAJOR = 3;

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        ResultSet resultSet = this.execute("CALL USER()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        ResultSet resultSet = this.execute("CALL isReadOnlyDatabase()");
        resultSet.next();
        boolean bl = resultSet.getBoolean(1);
        resultSet.close();
        return bl;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "HSQL Database Engine";
    }

    public String getDatabaseProductVersion() throws SQLException {
        ResultSet resultSet = this.execute("call database_version()");
        resultSet.next();
        return resultSet.getString(1);
    }

    public String getDriverName() throws SQLException {
        return "HSQL Database Engine Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "2.0.0";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "";
    }

    public String getNumericFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupNumericFunctions, ",", "");
    }

    public String getStringFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupStringFunctions, ",", "");
    }

    public String getSystemFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupSystemFunctions, ",", "");
    }

    public String getTimeDateFunctions() throws SQLException {
        return StringUtil.getList(FunctionCustom.openGroupDateTimeFunctions, ",", "");
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        Type type = Type.getDefaultTypeWithSize(Type.getHSQLDBTypeCode(n));
        Type type2 = Type.getDefaultTypeWithSize(Type.getHSQLDBTypeCode(n2));
        if (type == null || type2 == null) {
            return false;
        }
        return type2.canConvertFrom(type);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEMA";
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws SQLException {
        return "CATALOG";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return !this.useSchemaDefault;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 128;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 128;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 128;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 1 || n == 2 || n == 4 || n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_PROCEDURES", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PROCEDURES").append(JDBCDatabaseMetaData.and("PROCEDURE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || JDBCDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_PROCEDURECOLUMNS", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PROCEDURECOLUMNS").append(JDBCDatabaseMetaData.and("PROCEDURE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", string3)).append(JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || stringArray != null && stringArray.length == 0) {
            return this.executeSelect("SYSTEM_TABLES", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_TABLES").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", string3));
        if (stringArray != null) {
            stringBuffer.append(" AND TABLE_TYPE IN (").append(StringUtil.getList(stringArray, ",", "'")).append(')');
        }
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getSchemas() throws SQLException {
        return this.executeSelect("SYSTEM_SCHEMAS", null);
    }

    public ResultSet getCatalogs() throws SQLException {
        String string = "SELECT CATALOG_NAME AS TABLE_CAT FROM INFORMATION_SCHEMA.INFORMATION_SCHEMA_CATALOG_NAME";
        return this.execute(string);
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.executeSelect("SYSTEM_TABLETYPES", null);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || JDBCDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_COLUMNS", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_COLUMNS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", string3)).append(JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        String string5 = "SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM,TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE TRUE " + JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", string) + JDBCDatabaseMetaData.and("TABLE_SCHEMA", "=", string2) + JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3) + JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4);
        return this.execute(string5);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        String string4 = "SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM,TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TRUE " + JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", string) + JDBCDatabaseMetaData.and("TABLE_SCHEMA", "LIKE", string2) + JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", string3);
        return this.execute(string4);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4;
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        switch (n) {
            case 0: {
                string4 = BRI_TEMPORARY_SCOPE_IN_LIST;
                break;
            }
            case 1: {
                string4 = BRI_TRANSACTION_SCOPE_IN_LIST;
                break;
            }
            case 2: {
                string4 = BRI_SESSION_SCOPE_IN_LIST;
                break;
            }
            default: {
                throw Util.invalidArgument("scope");
            }
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        Integer n2 = bl ? null : INT_COLUMNS_NO_NULLS;
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_BESTROWIDENTIFIER").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(JDBCDatabaseMetaData.and("NULLABLE", "=", n2)).append(" AND SCOPE IN " + string4);
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_VERSIONCOLUMNS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PRIMARYKEYS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("FKTABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("FKTABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("FKTABLE_NAME", "=", string3)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("PKTABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PKTABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("PKTABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("parentTable");
        }
        if (string6 == null) {
            throw Util.nullArgument("foreignTable");
        }
        string = this.translateCatalog(string);
        string4 = this.translateCatalog(string4);
        string2 = this.translateSchema(string2);
        string5 = this.translateSchema(string5);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("PKTABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PKTABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("PKTABLE_NAME", "=", string3)).append(JDBCDatabaseMetaData.and("FKTABLE_CAT", "=", string4)).append(JDBCDatabaseMetaData.and("FKTABLE_SCHEM", "=", string5)).append(JDBCDatabaseMetaData.and("FKTABLE_NAME", "=", string6));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.executeSelect("SYSTEM_TYPEINFO", null);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string3 == null) {
            throw Util.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        Boolean bl3 = bl ? Boolean.FALSE : null;
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_INDEXINFO").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(JDBCDatabaseMetaData.and("NON_UNIQUE", "=", bl3));
        return this.execute(stringBuffer.toString());
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003 || n == 1004;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return this.supportsResultSetType(n) && (n2 == 1007 || n2 == 1008);
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || nArray != null && nArray.length == 0) {
            this.executeSelect("SYSTEM_UDTS", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_UDTS").append(JDBCDatabaseMetaData.and("TYPE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TYPE_NAME", "LIKE", string3));
        if (nArray != null) {
            stringBuffer.append(" AND DATA_TYPE IN (").append(StringUtil.getList(nArray, ",", "")).append(')');
        }
        return this.execute(stringBuffer.toString());
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (JDBCDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_SUPERTYPES", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefixNoSelect("SELECT * FROM (SELECT USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_SCHEMA, USER_DEFINED_TYPE_NAME,CAST (NULL AS INFORMATION_SCHEMA.SQL_IDENTIFIER), CAST (NULL AS INFORMATION_SCHEMA.SQL_IDENTIFIER), DATA_TYPE FROM INFORMATION_SCHEMA.USER_DEFINED_TYPES UNION SELECT DOMAIN_CATALOG, DOMAIN_SCHEMA, DOMAIN_NAME,NULL,NULL, DATA_TYPE FROM INFORMATION_SCHEMA.DOMAINS) AS SUPERTYPES(TYPE_CAT, TYPE_SCHEM, TYPE_NAME, SUPERTYPE_CAT, SUPERTYPE_SCHEM, SUPERTYPE_NAME) ").append(JDBCDatabaseMetaData.and("TYPE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TYPE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = this.toQueryPrefixNoSelect("SELECT TABLE_NAME AS TABLE_CAT, TABLE_NAME AS TABLE_SCHEM, TABLE_NAME, TABLE_NAME AS SUPERTABLE_NAME FROM INFORMATION_SCHEMA.TABLES ").append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", ""));
        return this.execute(stringBuffer.toString());
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = this.toQueryPrefixNoSelect("SELECT TABLE_NAME AS TYPE_CAT, TABLE_NAME AS TYPE_SCHME, TABLE_NAME AS TYPE_NAME, TABLE_NAME AS ATTR_NAME, CAST(0 AS INTEGER) AS DATA_TYPE, TABLE_NAME AS ATTR_TYPE_NAME, CAST(0 AS INTEGER) AS ATTR_SIZE, CAST(0 AS INTEGER) AS DECIMAL_DIGITS, CAST(0 AS INTEGER) AS NUM_PREC_RADIX, CAST(0 AS INTEGER) AS NULLABLE, '' AS REMARK, '' AS ATTR_DEF, CAST(0 AS INTEGER) AS SQL_DATA_TYPE, CAST(0 AS INTEGER) AS SQL_DATETIME_SUB, CAST(0 AS INTEGER) AS CHAR_OCTECT_LENGTH, CAST(0 AS INTEGER) AS ORDINAL_POSITION, '' AS NULLABLE, '' AS SCOPE_CATALOG, '' AS SCOPE_SCHEMA, '' AS SCOPE_TABLE, CAST(0 AS SMALLINT) AS SCOPE_DATA_TYPE FROM INFORMATION_SCHEMA.TABLES ").append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", ""));
        return this.execute(stringBuffer.toString());
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1 || n == 2;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        ResultSet resultSet = this.execute("call database_version()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return Integer.parseInt(string.substring(0, string.indexOf(".")));
    }

    public int getDatabaseMinorVersion() throws SQLException {
        ResultSet resultSet = this.execute("call database_version()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        int n = string.indexOf(".") + 1;
        return Integer.parseInt(string.substring(n, string.indexOf(".", n)));
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    JDBCDatabaseMetaData(JDBCConnection jDBCConnection) throws SQLException {
        this.connection = jDBCConnection;
        this.useSchemaDefault = jDBCConnection.isInternal ? false : jDBCConnection.connProperties.isPropertyTrue("default_schema");
    }

    private static String and(String string, String string2, Object object) {
        if (object == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = object instanceof String;
        if (bl && ((String)object).length() == 0) {
            return stringBuffer.append(" AND ").append(string).append(" IS NULL").toString();
        }
        String string3 = bl ? Type.SQL_VARCHAR.convertToSQLString(object) : String.valueOf(object);
        stringBuffer.append(" AND ").append(string).append(' ');
        if (bl && "LIKE".equalsIgnoreCase(string2)) {
            if (string3.indexOf(95) < 0 && string3.indexOf(37) < 0) {
                stringBuffer.append("=").append(' ').append(string3);
            } else {
                stringBuffer.append("LIKE").append(' ').append(string3);
                if (string3.indexOf("\\_") >= 0 || string3.indexOf("\\%") >= 0) {
                    stringBuffer.append(" ESCAPE '\\'");
                }
            }
        } else {
            stringBuffer.append(string2).append(' ').append(string3);
        }
        return stringBuffer.toString();
    }

    private ResultSet execute(String string) throws SQLException {
        JDBCStatement jDBCStatement = (JDBCStatement)this.connection.createStatement(1004, 1007);
        jDBCStatement.maxRows = -1;
        ResultSet resultSet = jDBCStatement.executeQuery(string);
        ((JDBCResultSet)resultSet).autoClose = true;
        return resultSet;
    }

    private ResultSet executeSelect(String string, String string2) throws SQLException {
        String string3 = selstar + string;
        if (string2 != null) {
            string3 = string3 + " WHERE " + string2;
        }
        return this.execute(string3);
    }

    private StringBuffer toQueryPrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer(255);
        return stringBuffer.append(selstar).append(string).append(whereTrue);
    }

    private StringBuffer toQueryPrefixNoSelect(String string) {
        StringBuffer stringBuffer = new StringBuffer(255);
        return stringBuffer.append(string).append(whereTrue);
    }

    private static boolean wantsIsNull(String string) {
        return string != null && string.length() == 0;
    }

    private String translateSchema(String string) throws SQLException {
        if (this.useSchemaDefault && string != null && string.length() == 0) {
            ResultSet resultSet = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return string;
        }
        return string;
    }

    private String translateCatalog(String string) throws SQLException {
        ResultSet resultSet;
        if (this.useSchemaDefault && string != null && string.length() == 0 && (resultSet = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE")).next()) {
            return resultSet.getString(2);
        }
        return string;
    }
}

