/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class ExpressionOp
extends Expression {
    static final ExpressionOp limitOneExpression = new ExpressionOp(95, new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER), new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER));

    ExpressionOp(int n, Expression expression, Expression expression2) {
        super(n);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        switch (this.opType) {
            case 92: 
            case 93: 
            case 95: 
            case 96: {
                return;
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }

    ExpressionOp(Expression expression, Type type) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        this.dataType = type;
        this.alias = expression.alias;
    }

    ExpressionOp(Expression expression) {
        super(expression.dataType.isDateTimeTypeWithZone() ? 91 : 92);
        switch (expression.dataType.typeCode) {
            case 94: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, expression, null);
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(92, expression.dataType.scale);
                break;
            }
            case 95: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, expression, null);
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(93, expression.dataType.scale);
                break;
            }
            case 92: {
                this.nodes = new Expression[2];
                this.nodes[0] = expression;
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(94, expression.dataType.scale);
                break;
            }
            case 93: {
                this.nodes = new Expression[2];
                this.nodes[0] = expression;
                this.nodes[0].dataType = expression.dataType;
                this.dataType = DateTimeType.getDateTimeType(95, expression.dataType.scale);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        this.alias = expression.alias;
    }

    public static Expression getCastExpression(Session session, Expression expression, Type type) {
        if (expression.getType() == 1) {
            Object object = type.castToType(session, expression.getValue(session), expression.getDataType());
            return new ExpressionValue(object, type);
        }
        return new ExpressionOp(expression, type);
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = ExpressionOp.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String string2 = ExpressionOp.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "ExpressionOp");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 91: {
                stringBuffer.append(' ').append("CAST").append('(');
                stringBuffer.append(string).append(' ').append("AS").append(' ');
                stringBuffer.append(this.dataType.getTypeDefinition());
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 93: {
                stringBuffer.append(' ').append("CASEWHEN").append('(');
                stringBuffer.append(string).append(',').append(string2).append(')');
                return stringBuffer.toString();
            }
            case 96: {
                stringBuffer.append(string).append(',').append(string2);
                return stringBuffer.toString();
            }
            case 95: {
                if (string != null) {
                    stringBuffer.append(' ').append("OFFSET").append(' ');
                    stringBuffer.append(string).append(' ');
                }
                if (string2 == null) break;
                stringBuffer.append(' ').append("FETCH").append(' ');
                stringBuffer.append("FIRST");
                stringBuffer.append(string2).append(' ').append(string2).append(' ');
                stringBuffer.append("ROWS").append(' ').append("ONLY");
                stringBuffer.append(' ');
                break;
            }
            case 92: {
                stringBuffer.append(string).append(' ').append("AT").append(' ');
                if (this.nodes[1] == null) {
                    stringBuffer.append("LOCAL").append(' ');
                    break;
                }
                stringBuffer.append(string2);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
        return stringBuffer.toString();
    }

    protected String describe(Session session, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuffer.append("VALUE = ").append(this.valueData);
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuffer.toString();
            }
            case 26: {
                stringBuffer.append("VALUELIST ");
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuffer.append(this.nodes[n2].describe(session, n + 1));
                    stringBuffer.append(' ');
                }
                break;
            }
            case 91: {
                stringBuffer.append("CAST ");
                stringBuffer.append(this.dataType.getTypeDefinition());
                stringBuffer.append(' ');
                break;
            }
            case 93: {
                stringBuffer.append("CASEWHEN ");
            }
        }
        if (this.getLeftNode() != null) {
            stringBuffer.append(" arg_left=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuffer.append(" arg_right=[");
            stringBuffer.append(this.nodes[1].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    public HsqlList resolveColumnReferences(RangeVariable[] rangeVariableArray, int n, HsqlList hsqlList, boolean bl) {
        if (this.opType == 1) {
            return hsqlList;
        }
        switch (this.opType) {
            case 93: {
                bl = false;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            hsqlList = this.nodes[i].resolveColumnReferences(rangeVariableArray, n, hsqlList, bl);
        }
        return hsqlList;
    }

    public void resolveTypes(Session session, Expression expression) {
        block0 : switch (this.opType) {
            case 1: {
                break;
            }
            case 91: {
                this.nodes[0].resolveTypes(session, this);
                Type type = this.nodes[0].dataType;
                if (type != null && !this.dataType.canConvertFrom(type)) {
                    throw Error.error(5561);
                }
                if (this.nodes[0].opType == 1) {
                    Expression expression2 = this.nodes[0];
                    this.setAsConstantValue(session);
                    expression2.dataType = this.dataType;
                    expression2.valueData = this.valueData;
                    if (expression == null) break;
                    expression.replaceNode(this, expression2);
                    break;
                }
                if (this.nodes[0].opType == 8) {
                    this.nodes[0].dataType = this.dataType;
                    if (expression == null || expression.isSelfAggregate()) break;
                    break;
                }
                if (!this.dataType.equals(this.nodes[0].dataType)) break;
                break;
            }
            case 92: {
                this.nodes[0].resolveTypes(session, this);
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1] != null) {
                    this.nodes[1].resolveTypes(session, this);
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                    }
                    if (this.nodes[1].dataType.typeCode != 111) {
                        throw Error.error(5563);
                    }
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 92: {
                        this.dataType = DateTimeType.getDateTimeType(94, this.nodes[0].dataType.scale);
                        break block0;
                    }
                    case 93: {
                        this.dataType = DateTimeType.getDateTimeType(95, this.nodes[0].dataType.scale);
                        break block0;
                    }
                    case 94: 
                    case 95: {
                        this.dataType = this.nodes[0].dataType;
                        break block0;
                    }
                }
                throw Error.error(5563);
            }
            case 93: {
                this.resolveTypesForCaseWhen(session);
                break;
            }
            case 95: {
                for (int i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i] == null) continue;
                    this.nodes[i].resolveTypes(session, this);
                    if (this.nodes[i].dataType != null) continue;
                    this.nodes[i].dataType = Type.SQL_INTEGER;
                }
                break;
            }
            case 96: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionOp");
            }
        }
    }

    void resolveTypesForCaseWhen(Session session) {
        if (this.dataType != null) {
            return;
        }
        Expression expression = this;
        while (expression.opType == 93) {
            expression.nodes[0].resolveTypes(session, expression);
            if (expression.nodes[0].isUnresolvedParam()) {
                expression.nodes[0].dataType = Type.SQL_BOOLEAN;
            }
            expression.nodes[1].nodes[0].resolveTypes(session, this.nodes[1]);
            expression.nodes[1].nodes[1].resolveTypes(session, this.nodes[1]);
            expression = expression.nodes[1].nodes[1];
        }
        expression = this;
        while (expression.opType == 93) {
            this.dataType = Type.getAggregateType(expression.nodes[1].nodes[0].dataType, this.dataType);
            this.dataType = Type.getAggregateType(expression.nodes[1].nodes[1].dataType, this.dataType);
            expression = expression.nodes[1].nodes[1];
        }
        expression = this;
        while (expression.opType == 93) {
            if (expression.nodes[1].nodes[0].dataType == null) {
                expression.nodes[1].nodes[0].dataType = this.dataType;
            }
            if (expression.nodes[1].nodes[1].dataType == null) {
                expression.nodes[1].nodes[1].dataType = this.dataType;
            }
            if (expression.nodes[1].dataType == null) {
                expression.nodes[1].dataType = this.dataType;
            }
            expression = expression.nodes[1].nodes[1];
        }
        if (this.dataType == null) {
            throw Error.error(5567);
        }
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object[] objectArray = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return objectArray[this.columnIndex];
            }
            case 94: {
                return this.nodes[0].getValue(session);
            }
            case 91: {
                Object object = this.dataType.castToType(session, this.nodes[0].getValue(session), this.nodes[0].dataType);
                if (this.dataType.userTypeModifier != null) {
                    Constraint[] constraintArray = this.dataType.userTypeModifier.getConstraints();
                    for (int i = 0; i < constraintArray.length; ++i) {
                        constraintArray[i].checkCheckConstraint(session, null, object);
                    }
                }
                return object;
            }
            case 93: {
                Boolean bl = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(bl)) {
                    return this.nodes[1].nodes[0].getValue(session, this.dataType);
                }
                return this.nodes[1].nodes[1].getValue(session, this.dataType);
            }
            case 92: {
                Object object;
                Object object2 = this.nodes[0].getValue(session);
                Object object3 = object = this.nodes[1] == null ? null : this.nodes[1].getValue(session);
                if (object2 == null) {
                    return null;
                }
                if (this.nodes[1] != null && object == null) {
                    return null;
                }
                long l = this.nodes[1] == null ? (long)session.getZoneSeconds() : ((IntervalType)this.nodes[1].dataType).getSeconds(object);
                return ((DateTimeType)this.dataType).changeZone(object2, this.nodes[0].dataType, (int)l, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "ExpressionOp");
    }
}

