/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers;

import java.util.ArrayList;
import java.util.List;
import org.hpccsystems.ws.client.wrappers.XRefFilePartWrapper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XRefFileWrapper {
    private static final String PARTS_FOUND_TAG = "Partsfound";
    private static final String PART_MASK_TAG = "Partmask";
    private static final String SIZE_TAG = "Size";
    private static final String MODIFIED_TAG = "Modified";
    private static final String NUM_PARTS_TAG = "Numparts";
    private static final String PART_TAG = "Part";
    private int partsfound = -1;
    private String partmask = null;
    private long size = -1L;
    private String modified = null;
    private int numparts = -1;
    private List<XRefFilePartWrapper> parts = new ArrayList<XRefFilePartWrapper>();

    public XRefFileWrapper(Node xreffilenode) {
        this.populatefile(xreffilenode);
    }

    public int getPartsfound() {
        return this.partsfound;
    }

    public void setPartsfound(int partsfound) {
        this.partsfound = partsfound;
    }

    public String getPartmask() {
        return this.partmask;
    }

    public void setPartmask(String partmask) {
        this.partmask = partmask;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getModified() {
        return this.modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public int getNumparts() {
        return this.numparts;
    }

    public void setNumparts(int numparts) {
        this.numparts = numparts;
    }

    public void addPart(XRefFilePartWrapper part) {
        this.parts.add(part);
    }

    private void populatefile(Node currentNode) {
        try {
            NodeList currentChildren = currentNode.getChildNodes();
            for (int childindex = 0; childindex < currentChildren.getLength(); ++childindex) {
                Node childNode = currentChildren.item(childindex);
                String tagName = childNode.getNodeName();
                if (tagName.equalsIgnoreCase(PARTS_FOUND_TAG)) {
                    this.setPartsfound(Integer.valueOf(childNode.getTextContent()));
                    continue;
                }
                if (tagName.equalsIgnoreCase(PART_MASK_TAG)) {
                    this.setPartmask(childNode.getTextContent());
                    continue;
                }
                if (tagName.equalsIgnoreCase(SIZE_TAG)) {
                    this.setSize(Long.valueOf(childNode.getTextContent()));
                    continue;
                }
                if (tagName.equalsIgnoreCase(MODIFIED_TAG)) {
                    this.setModified(childNode.getTextContent());
                    continue;
                }
                if (tagName.equalsIgnoreCase(NUM_PARTS_TAG)) {
                    this.setNumparts(Integer.valueOf(childNode.getTextContent()));
                    continue;
                }
                if (!tagName.equalsIgnoreCase(PART_TAG)) continue;
                this.addPart(new XRefFilePartWrapper(childNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        String out = "XRefFile:\n\tPartsfound: " + this.partsfound + "\n\tPartmask: " + this.partmask + "\n\tSize: " + this.size + "\n\tModified: " + this.modified + "\n\tNumparts: " + this.numparts;
        out = out + "\n\tParts: [";
        for (XRefFilePartWrapper xRefFilePartWrapper : this.parts) {
            out = out + " " + xRefFilePartWrapper.toString();
        }
        out = out + "]\n";
        return out;
    }
}

