/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hpccsystems.ws.client.wrappers.XRefMessageWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ArrayOfXRefMessageWrapper {
    protected List<XRefMessageWrapper> messages = new ArrayList<XRefMessageWrapper>();
    protected String cluster = null;
    private static final String WARNING_TAG = "Warning";
    private static final String ERROR_TAG = "Error";
    private static final String CLUSTER_TAG = "Cluster";

    public String getCluster() {
        return this.cluster;
    }

    public ArrayOfXRefMessageWrapper(String response) {
        if (response != null && !response.isEmpty()) {
            try {
                int index;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new ByteArrayInputStream(response.getBytes("UTF-8")));
                NodeList xrefnodelist = doc.getElementsByTagName(WARNING_TAG);
                for (index = 0; index < xrefnodelist.getLength(); ++index) {
                    this.messages.add(new XRefMessageWrapper(xrefnodelist.item(index)));
                }
                xrefnodelist = doc.getElementsByTagName(ERROR_TAG);
                for (index = 0; index < xrefnodelist.getLength(); ++index) {
                    this.messages.add(new XRefMessageWrapper(xrefnodelist.item(index)));
                }
                xrefnodelist = doc.getElementsByTagName(CLUSTER_TAG);
                if (xrefnodelist.getLength() > 0) {
                    this.cluster = xrefnodelist.item(0).getTextContent();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        String out = "XRefMessages (cluster: '" + this.cluster + "'):\n";
        for (XRefMessageWrapper message : this.messages) {
            out = out + "\t" + message.toString() + "\n";
        }
        return out;
    }
}

