/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hpccsystems.ws.client.wrappers.XRefDirectoryWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArrayOfXRefDirectoryWrapper {
    private List<XRefDirectoryWrapper> directories = new ArrayList<XRefDirectoryWrapper>();
    private String cluster = null;
    private static final String CLUSTER_TAG = "Cluster";
    private static final String DIRECTORY_TAG = "Directory";

    public ArrayOfXRefDirectoryWrapper(String wsdfuxrefresponse) {
        if (wsdfuxrefresponse != null && !wsdfuxrefresponse.isEmpty()) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new ByteArrayInputStream(wsdfuxrefresponse.getBytes("UTF-8")));
                NodeList xrefnodelist = doc.getElementsByTagName(CLUSTER_TAG);
                if (xrefnodelist.getLength() > 0) {
                    this.cluster = xrefnodelist.item(0).getTextContent();
                }
                xrefnodelist = doc.getElementsByTagName(DIRECTORY_TAG);
                for (int index = 0; index < xrefnodelist.getLength(); ++index) {
                    Node currentNode = xrefnodelist.item(index);
                    this.directories.add(new XRefDirectoryWrapper(currentNode));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<XRefDirectoryWrapper> getDirectories() {
        return this.directories;
    }

    public void addDirectory(XRefDirectoryWrapper dir) {
        this.directories.add(dir);
    }

    public String toString() {
        String out = "Cluster: " + this.cluster + "\nDirectories:\n";
        for (XRefDirectoryWrapper xRefDirectoryWrapper : this.directories) {
            out = out + "\t" + xRefDirectoryWrapper.toString() + "\n";
        }
        return out;
    }
}

