/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform.test;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.hpccsystems.commons.annotations.RemoteTests;
import org.hpccsystems.ws.client.HPCCWsClient;
import org.hpccsystems.ws.client.HPCCWsTopologyClient;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpGroupWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WorkunitWrapper;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={RemoteTests.class})
public abstract class BaseRemoteTest {
    protected static Platform platform;
    protected static HPCCWsClient wsclient;
    protected static final String connString;
    protected static String thorClusterFileGroup;
    protected static final String thorclustername;
    protected static String roxieClusterGroup;
    protected static final String roxieclustername;
    protected static final String defaultUserName = "JunitUser";
    protected static Connection connection;
    protected static final String hpccUser;
    protected static final String hpccPass;
    protected static final Integer connTO;
    protected static final String sockTO;
    public static final String DEFAULTHPCCFILENAME = "benchmark::all_types::200kb";
    public static final String DEFAULTHPCCSUPERFILENAME = "benchmark::all_types::superfile";

    public String executeECLScript(String eclFile) throws Exception {
        URL eclFileURL = this.getClass().getClassLoader().getResource(eclFile);
        Path eclFilePath = Paths.get(eclFileURL.toURI());
        byte[] eclData = Files.readAllBytes(eclFilePath);
        String ecl = new String(eclData, "UTF-8");
        WorkunitWrapper wu = new WorkunitWrapper();
        wu.setECL(ecl);
        wu.setJobname("UnitTest ECL Script: " + eclFile);
        wu.setCluster(thorclustername);
        HPCCWsWorkUnitsClient client = wsclient.getWsWorkunitsClient();
        return client.createAndRunWUFromECLAndGetResults(wu);
    }

    static {
        connString = System.getProperty("hpccconn", "http://localhost:8010");
        thorClusterFileGroup = System.getProperty("thorgroupname");
        thorclustername = System.getProperty("thorclustername", "thor");
        roxieClusterGroup = System.getProperty("roxiegroupname");
        roxieclustername = System.getProperty("roxieclustername", "roxie");
        connection = null;
        hpccUser = System.getProperty("hpccuser", defaultUserName);
        hpccPass = System.getProperty("hpccpass", "");
        connTO = System.getProperty("connecttimeoutmillis") == null ? null : Integer.valueOf(System.getProperty("connecttimeoutmillis"));
        sockTO = System.getProperty("sockettimeoutmillis");
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return hostname.equals("localhost");
            }
        });
        String legacythorcluster = System.getProperty("thorcluster");
        if (legacythorcluster != null && !legacythorcluster.isEmpty()) {
            System.out.println("WARNING! 'thorcluster' has been deprecated - Use 'thorclustername' and/or 'thorgroupname' instead");
        }
        if (System.getProperty("thorclustername") == null) {
            System.out.println("thorclustername not provided - defaulting to '" + thorclustername + "'");
        }
        if (System.getProperty("roxieclustername") == null) {
            System.out.println("roxieclustername not provided - defaulting to '" + roxieclustername + "'");
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getHostName();
            System.out.println("RemoteTest executing on: " + hostname + "(" + ip + ")");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (System.getProperty("hpccconn") == null) {
            System.out.println("RemoteTest: No 'hpccconn' provided, defaulting to http://localhost:8010");
        } else {
            System.out.println("RemoteTest: 'hpccconn' set to: '" + connString + "'");
        }
        if (System.getProperty("hpccuser") == null) {
            System.out.println("RemoteTest: No 'hpccuser' provided, defaulting to 'JunitUser'");
        } else {
            System.out.println("RemoteTest: 'hpccuser' set to: '" + hpccUser + "'");
        }
        if (System.getProperty("hpccpass") == null) {
            System.out.println("RemoteTest: No 'hpccpass' provided.");
        }
        if (platform == null) {
            try {
                connection = new Connection(connString);
            }
            catch (MalformedURLException e) {
                Assert.fail((String)("Could not adquire connection object based on: '" + connString + "' - " + e.getLocalizedMessage()));
            }
            Assert.assertNotNull((String)"Could not adquire connection object", (Object)connection);
            connection.setCredentials(hpccUser, hpccPass);
            if (connTO != null) {
                connection.setConnectTimeoutMilli(connTO);
            }
            if (sockTO != null) {
                connection.setSocketTimeoutMilli(Integer.valueOf(sockTO));
            }
            platform = Platform.get(connection);
            Assert.assertNotNull((String)"Could not adquire platform object", (Object)platform);
        }
        try {
            TpGroupWrapper tpGroupWrapper;
            Iterator<TpGroupWrapper> iterator;
            List<TpGroupWrapper> grouplist;
            wsclient = platform.checkOutHPCCWsClient();
            if (thorClusterFileGroup == null || thorClusterFileGroup.isEmpty()) {
                grouplist = wsclient.getTopologyGroups(wsclient.isContainerized() ? HPCCWsTopologyClient.TopologyGroupQueryKind.PLANE : HPCCWsTopologyClient.TopologyGroupQueryKind.THOR);
                iterator = grouplist.iterator();
                while (iterator.hasNext() && (thorClusterFileGroup = (tpGroupWrapper = iterator.next()).getName()) == null) {
                }
                System.out.println("RemoteTest: No 'thorClusterFileGroup' provided, using '" + thorClusterFileGroup + "'");
            } else {
                System.out.println("RemoteTest: 'thorClusterFileGroup': '" + thorClusterFileGroup + "'");
            }
            if (roxieClusterGroup == null || roxieClusterGroup.isEmpty()) {
                grouplist = wsclient.getTopologyGroups(wsclient.isContainerized() ? HPCCWsTopologyClient.TopologyGroupQueryKind.PLANE : HPCCWsTopologyClient.TopologyGroupQueryKind.ROXIE);
                iterator = grouplist.iterator();
                while (iterator.hasNext() && (roxieClusterGroup = (tpGroupWrapper = iterator.next()).getName()) == null) {
                }
                System.out.println("RemoteTest: No 'roxiegroupname' provided, using '" + roxieClusterGroup + "'");
            } else {
                System.out.println("RemoteTest: 'roxiegroupname': '" + roxieclustername + "'");
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Could not adquire wsclient object: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Could not adquire wsclient object", (Object)wsclient);
    }
}

