/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.HashMap;
import java.util.Map;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.gen.filespray.PhysicalFileStructWrapper;

public class PhysicalFile
extends DataSingleton {
    private static Map<Integer, PhysicalFile> PhysicalFiles = new HashMap<Integer, PhysicalFile>();
    private Platform platform;
    private PhysicalFileStructWrapper physicalfilestruct;

    public static synchronized PhysicalFile get(Platform platform, String name) {
        PhysicalFile physicalFile = new PhysicalFile(platform, name);
        if (PhysicalFiles.containsKey(physicalFile.hashCode())) {
            return PhysicalFiles.get(physicalFile.hashCode());
        }
        PhysicalFiles.put(physicalFile.hashCode(), physicalFile);
        return physicalFile;
    }

    public static synchronized PhysicalFile get(Platform platform, PhysicalFileStructWrapper fileStruct) {
        PhysicalFile physicalFile = PhysicalFile.get(platform, fileStruct.getName());
        physicalFile.update(fileStruct);
        return physicalFile;
    }

    private PhysicalFile(Platform platform, String name) {
        this.platform = platform;
        this.physicalfilestruct = new PhysicalFileStructWrapper();
        this.physicalfilestruct.setName(name);
    }

    public String getName() {
        return this.physicalfilestruct.getName();
    }

    public Long getFilesize() {
        return this.physicalfilestruct.getFilesize();
    }

    public String getModifiedtime() {
        return this.physicalfilestruct.getModifiedtime();
    }

    public boolean getIsDir() {
        return this.physicalfilestruct.getIsDir();
    }

    public String getPath() {
        return this.physicalfilestruct.getPath();
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
    }

    public void update(PhysicalFileStructWrapper file) {
        if (this.physicalfilestruct.getName().equals(file.getName())) {
            this.physicalfilestruct = file;
        }
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof PhysicalFile)) {
            return false;
        }
        PhysicalFile that = (PhysicalFile)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.physicalfilestruct.getName(), that.physicalfilestruct.getName());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.physicalfilestruct.getName());
        return result;
    }

    public static enum Notification {
        PHYSICALFILE;

    }
}

