/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.antlr;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Recognizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.antlr.ErrorListener;
import org.hpccsystems.ws.client.antlr.gen.EclRecordBaseListener;
import org.hpccsystems.ws.client.antlr.gen.EclRecordParser;
import org.hpccsystems.ws.client.platform.DFUDataColumnAnnotation;
import org.hpccsystems.ws.client.wrappers.EclRecordWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUDataColumnWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFURecordDefWrapper;

public class EclRecordReader
extends EclRecordBaseListener {
    private static final Logger log = LogManager.getLogger(EclRecordReader.class);
    private ErrorListener errorHandler = new ErrorListener();
    private EclRecordWrapper eclWraper = new EclRecordWrapper();
    private DFURecordDefWrapper currentrec = null;
    private List<DFURecordDefWrapper> parentrecs = new ArrayList<DFURecordDefWrapper>();
    private DFUDataColumnWrapper currentfield = null;
    private List<DFUDataColumnWrapper> parentfields = new ArrayList<DFUDataColumnWrapper>();
    private EclRecordParser parser = null;
    private List<String> annotationParams = new ArrayList<String>();
    private String annotationName = null;

    @Override
    public void enterRecord_def_inline(EclRecordParser.Record_def_inlineContext ctx) {
        this.currentrec = new DFURecordDefWrapper();
        this.currentrec.setInline(true);
    }

    @Override
    public void exitRecord_def_inline(EclRecordParser.Record_def_inlineContext ctx) {
        this.eclWraper.addRecordset(this.currentrec);
        this.currentrec = null;
    }

    @Override
    public void enterRecord_def(EclRecordParser.Record_defContext ctx) {
        if (this.currentrec == null) {
            this.currentrec = new DFURecordDefWrapper();
        }
        this.eclWraper.addRecordset(this.currentrec);
    }

    @Override
    public void exitRecord_def(EclRecordParser.Record_defContext ctx) {
        this.currentrec = null;
    }

    @Override
    public void enterDefined_record_def(EclRecordParser.Defined_record_defContext ctx) {
        this.currentrec = new DFURecordDefWrapper();
        this.currentrec.setRecordName(ctx.getChild(0).getText());
    }

    @Override
    public void enterEclfield_decl(EclRecordParser.Eclfield_declContext ctx) {
        this.currentfield = new DFUDataColumnWrapper();
    }

    @Override
    public void exitEclfield_decl(EclRecordParser.Eclfield_declContext ctx) {
        if (ctx.getChildCount() == 1 && ctx.getChild(0).getChildCount() == 3) {
            String recset = ctx.getChild(0).getChild(1).getText();
            if (!this.eclWraper.getRecordsets().containsKey(recset)) {
                this.errorHandler.syntaxError((Recognizer<?, ?>)this.getParser(), recset, ctx.start.getLine(), ctx.start.getStartIndex(), "Record definition " + recset + " reference in " + ctx.getParent().getText() + " not found ", null);
            }
            DFURecordDefWrapper recnew = new DFURecordDefWrapper();
            if (this.eclWraper.getRecordsets().containsKey(recset)) {
                recnew.getChildColumns().addAll(this.eclWraper.getRecordsets().get(recset).getChildColumns());
            }
            recnew.setColumnLabel(this.currentfield.getColumnLabel());
            recnew.setColumnEclType(this.currentfield.getColumnEclType());
            recnew.setColumnType(this.currentfield.getColumnType());
            recnew.setRecordLayoutName(recset);
            recnew.setSingleRow(true);
            this.currentrec.getChildColumns().add(recnew);
        } else if (!(this.currentfield instanceof DFURecordDefWrapper)) {
            if (ctx.getChildCount() > 0 && this.currentfield.getColumnEclType() == null) {
                if (ctx.getChild(0).getChildCount() == 2) {
                    this.currentfield.setColumnEclType(ctx.getChild(0).getChild(0).getText() + " " + ctx.getChild(0).getChild(1).getText());
                    this.currentfield.setColumnType(this.currentfield.getColumnEclType());
                } else {
                    this.currentfield.setColumnEclType(ctx.getChild(0).getText());
                    this.currentfield.setColumnType(this.currentfield.getColumnEclType());
                }
            }
            if (ctx.getChildCount() > 1) {
                this.currentfield.setColumnLabel(ctx.getChild(1).getText());
            }
        }
        if (this.eclWraper.getRecordsets().containsKey(this.currentfield.getColumnEclType())) {
            DFURecordDefWrapper recnew = new DFURecordDefWrapper();
            recnew.getChildColumns().addAll(this.eclWraper.getRecordsets().get(this.currentfield.getColumnEclType()).getChildColumns());
            recnew.setColumnLabel(this.currentfield.getColumnLabel());
            recnew.setColumnEclType(this.currentfield.getColumnEclType());
            recnew.setColumnType(this.currentfield.getColumnType());
            recnew.setRecordLayoutName(this.currentfield.getColumnEclType());
            recnew.setSingleRow(true);
            this.currentrec.getChildColumns().add(recnew);
        } else {
            this.currentrec.getChildColumns().add(this.currentfield);
        }
        this.currentfield = null;
    }

    @Override
    public void enterMaxcount(EclRecordParser.MaxcountContext ctx) {
        if (this.currentfield != null) {
            this.currentfield.setMaxcount(ctx.getChild(2).getText());
        } else {
            this.currentrec.setMaxcount(ctx.getChild(2).getText());
        }
    }

    @Override
    public void enterBlob(EclRecordParser.BlobContext ctx) {
        if (this.currentfield != null) {
            this.currentfield.setBlob(true);
        }
    }

    @Override
    public void enterNested_dataset_decl(EclRecordParser.Nested_dataset_declContext ctx) {
        this.currentfield = new DFURecordDefWrapper();
        DFURecordDefWrapper rcurrent = (DFURecordDefWrapper)this.currentfield;
        if (ctx.getChildCount() >= 5) {
            rcurrent.setRecordLayoutName(ctx.getChild(2).getText());
            rcurrent.setRecordName(ctx.getChild(4).getText());
            if (this.eclWraper.getRecordsets().containsKey(rcurrent.getRecordLayoutName())) {
                this.currentfield.getChildColumns().addAll(this.eclWraper.getRecordsets().get(rcurrent.getRecordLayoutName()).getChildColumns());
            } else {
                log.error("Unknown record layout " + rcurrent.getRecordLayoutName());
            }
        } else {
            log.error("Unknown format " + ctx.getText());
        }
    }

    @Override
    public void enterNested_inline_dataset_decl(EclRecordParser.Nested_inline_dataset_declContext ctx) {
        this.currentfield = new DFURecordDefWrapper();
        this.currentfield.setColumnLabel(ctx.getChild(4).getText());
        ((DFURecordDefWrapper)this.currentfield).setInline(true);
    }

    @Override
    public void enterInline_dataset_record_def(EclRecordParser.Inline_dataset_record_defContext ctx) {
        this.parentrecs.add(0, this.currentrec);
        this.currentrec = new DFURecordDefWrapper();
        this.parentfields.add(0, this.currentfield);
    }

    @Override
    public void enterExploded_dataset_record_def(EclRecordParser.Exploded_dataset_record_defContext ctx) {
        this.parentrecs.add(0, this.currentrec);
        this.currentrec = new DFURecordDefWrapper();
        this.parentfields.add(0, this.currentfield);
    }

    @Override
    public void exitInline_dataset_record_def(EclRecordParser.Inline_dataset_record_defContext ctx) {
        if (this.parentfields.size() > 0) {
            this.parentfields.get(0).getChildColumns().addAll(this.currentrec.getChildColumns());
        }
        this.currentrec = this.parentrecs.get(0);
        this.currentfield = this.parentfields.get(0);
        this.parentfields.remove(0);
        this.parentrecs.remove(0);
    }

    @Override
    public void exitExploded_dataset_record_def(EclRecordParser.Exploded_dataset_record_defContext ctx) {
        if (this.parentfields.size() > 0) {
            this.parentfields.get(0).getChildColumns().addAll(this.currentrec.getChildColumns());
        }
        this.currentrec = this.parentrecs.get(0);
        this.currentfield = this.parentfields.get(0);
        this.parentfields.remove(0);
        this.parentrecs.remove(0);
    }

    @Override
    public void enterMaxlength(EclRecordParser.MaxlengthContext ctx) {
        if (this.currentfield != null) {
            this.currentfield.setMaxlength(ctx.getChild(2).getText());
        } else if (this.currentrec != null) {
            this.currentrec.setMaxRecLength(ctx.getChild(2).getText());
        }
    }

    public ErrorListener getErrorHandler() {
        return this.errorHandler;
    }

    public EclRecordWrapper getEclRecordWrapper() {
        return this.eclWraper;
    }

    public EclRecordParser getParser() {
        return this.parser;
    }

    public void setParser(EclRecordParser parser) {
        this.parser = parser;
    }

    @Override
    public void enterDefaultval(EclRecordParser.DefaultvalContext ctx) {
        String val = ctx.getChild(2).getText();
        val = val.replace("'", "");
        if (this.currentfield != null) {
            this.currentfield.setColumnValue(val);
        } else if (this.currentrec != null) {
            this.currentrec.setColumnValue(val);
        }
    }

    @Override
    public void enterXpath(EclRecordParser.XpathContext ctx) {
        String val = ctx.getChild(2).getText();
        if (val.startsWith("'")) {
            val = val.substring(1);
        }
        if (val.endsWith("'")) {
            val = val.substring(0, val.length() - 1);
        }
        if (this.currentfield != null) {
            this.currentfield.setXpath(val);
        } else if (this.currentrec != null) {
            this.currentrec.setXpath(val);
        }
    }

    @Override
    public void enterXmldefaultval(EclRecordParser.XmldefaultvalContext ctx) {
        String val = ctx.getChild(2).getText();
        val = val.replace("'", "");
        if (this.currentfield != null) {
            this.currentfield.setXmlDefaultVal(val);
        } else if (this.currentrec != null) {
            this.currentrec.setXmlDefaultVal(val);
        }
    }

    @Override
    public void enterComment(EclRecordParser.CommentContext ctx) {
        super.enterComment(ctx);
    }

    @Override
    public void exitAnnotation(EclRecordParser.AnnotationContext ctx) {
        super.exitAnnotation(ctx);
        if (this.currentrec.getChildColumns().size() > 0) {
            DFUDataColumnWrapper info = this.currentrec.getChildColumns().get(this.currentrec.getChildColumns().size() - 1);
            info.getAnnotations().add(new DFUDataColumnAnnotation(this.annotationName, this.annotationParams));
        } else {
            this.currentrec.getAnnotations().add(new DFUDataColumnAnnotation(this.annotationName, this.annotationParams));
        }
    }

    @Override
    public void exitAnnotation_name(EclRecordParser.Annotation_nameContext ctx) {
        this.annotationName = ctx.getChild(0).getText().substring(1);
        super.exitAnnotation_name(ctx);
    }

    @Override
    public void exitAnnotation_param(EclRecordParser.Annotation_paramContext ctx) {
        super.exitAnnotation_param(ctx);
        this.annotationParams.add(ctx.getChild(0).getText());
    }

    @Override
    public void exitComment(EclRecordParser.CommentContext ctx) {
        super.exitComment(ctx);
    }

    @Override
    public void enterAnnotation(EclRecordParser.AnnotationContext ctx) {
        super.enterAnnotation(ctx);
        this.annotationName = null;
        this.annotationParams = new ArrayList<String>();
    }
}

