/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.dfs.client.IRecordBuilder;

public class ReflectionRecordBuilder<T>
implements IRecordBuilder {
    private Field[] fields = null;
    private FieldDef fieldDef = null;
    private ReflectionRecordBuilder<T>[] childRecordBuilders = null;
    private T record = null;
    private Class<T> recordClass = null;

    ReflectionRecordBuilder(Class<T> clazz, FieldDef recordDef) {
        this.recordClass = clazz;
        this.setRecordDefinition(recordDef);
    }

    @Override
    public void setRecordDefinition(FieldDef recordDef) {
        FieldDef fd;
        int i;
        this.fieldDef = recordDef;
        this.childRecordBuilders = new ReflectionRecordBuilder[this.fieldDef.getNumDefs()];
        for (i = 0; i < this.fieldDef.getNumDefs(); ++i) {
            boolean needsChildRecordBuilder;
            fd = this.fieldDef.getDef(i);
            boolean bl = needsChildRecordBuilder = fd.getFieldType() == FieldType.RECORD || fd.getFieldType() == FieldType.DATASET && fd.getDef(0).getFieldType() == FieldType.RECORD;
            if (needsChildRecordBuilder) {
                try {
                    Field field = this.recordClass.getDeclaredField(fd.getFieldName());
                    field.setAccessible(true);
                    this.fields[i] = field;
                    FieldDef subFd = fd;
                    Class subClass = field.getType();
                    if (fd.getFieldType() == FieldType.DATASET) {
                        ParameterizedType pType;
                        Type[] fieldArgTypes;
                        subClass = null;
                        Type genericFieldType = field.getGenericType();
                        if (genericFieldType instanceof ParameterizedType && (fieldArgTypes = (pType = (ParameterizedType)genericFieldType).getActualTypeArguments()).length > 0) {
                            subClass = (Class)fieldArgTypes[0];
                        }
                        subFd = fd.getDef(0);
                    }
                    this.childRecordBuilders[i] = new ReflectionRecordBuilder(subClass, subFd);
                }
                catch (Exception e) {
                    this.childRecordBuilders[i] = null;
                }
                continue;
            }
            this.childRecordBuilders[i] = null;
        }
        this.fields = new Field[this.fieldDef.getNumDefs()];
        for (i = 0; i < this.fieldDef.getNumDefs(); ++i) {
            fd = this.fieldDef.getDef(i);
            try {
                Field field = this.recordClass.getDeclaredField(fd.getFieldName());
                field.setAccessible(true);
                this.fields[i] = field;
                continue;
            }
            catch (Exception e) {
                this.fields[i] = null;
            }
        }
    }

    @Override
    public FieldDef getRecordDefinition() {
        return this.fieldDef;
    }

    @Override
    public void startRecord() throws InstantiationException {
        try {
            this.record = this.recordClass.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException();
        }
    }

    @Override
    public Object finalizeRecord() throws InstantiationException {
        return this.record;
    }

    @Override
    public void setFieldValue(int index, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (this.fields[index] != null) {
            this.fields[index].set(this.record, value);
        }
    }

    @Override
    public IRecordBuilder getChildRecordBuilder(int index) {
        return this.childRecordBuilders[index];
    }
}

