/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.Serializable;
import org.hpccsystems.commons.ecl.FileFilter;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.cluster.ClusterRemapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFilePartWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileTypeWrapper;

public class DataPartition
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String[] copyLocations;
    private String[] copyPaths;
    private int this_part;
    private int num_parts;
    private int rowservicePort;
    private boolean useSSL;
    private FileFilter fileFilter;
    private String fileAccessBlob;
    private FileType fileType;
    private boolean isTLK;

    public DataPartition(String[] copyLocations, String[] copyPaths, int partNum, int numParts, int rowServicePort, boolean shouldUseSSL, String fileAccessBlob) {
        this(copyLocations, copyPaths, partNum, numParts, rowServicePort, shouldUseSSL, null, fileAccessBlob);
    }

    private DataPartition(String[] copyLocations, String[] copyPaths, int partNum, int numParts, int rowServicePort, boolean shouldUseSSL, FileFilter filter, String fileAccessBlob) {
        this(copyLocations, copyPaths, partNum, numParts, rowServicePort, shouldUseSSL, null, fileAccessBlob, FileType.FLAT);
    }

    private DataPartition(String[] copylocations, String[] copyPaths, int this_part, int num_parts, int clearport, boolean sslport, FileFilter filter, String fileAccessBlob, FileType fileType) {
        this.this_part = this_part;
        this.num_parts = num_parts;
        this.rowservicePort = clearport;
        this.useSSL = sslport;
        this.fileFilter = filter;
        if (this.fileFilter == null) {
            this.fileFilter = new FileFilter();
        }
        this.fileType = fileType;
        this.fileAccessBlob = fileAccessBlob;
        this.copyLocations = copylocations;
        this.copyPaths = copyPaths;
    }

    public String getFileAccessBlob() {
        return this.fileAccessBlob;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String[] getCopyLocations() {
        return this.copyLocations;
    }

    public String getCopyIP(int copyindex) {
        int copiescount = this.copyLocations.length;
        if (copyindex < 0 || copyindex >= copiescount) {
            return null;
        }
        return this.copyLocations[copyindex];
    }

    public int getCopyCount() {
        return this.copyLocations.length;
    }

    public int getPort() {
        return this.rowservicePort;
    }

    public boolean getUseSsl() {
        return this.useSSL;
    }

    public String getCopyPath(int index) {
        if (index >= this.copyPaths.length) {
            return null;
        }
        return this.copyPaths[index];
    }

    public int getThisPart() {
        return this.this_part;
    }

    public int getNumParts() {
        return this.num_parts;
    }

    public FileFilter getFilter() {
        return this.fileFilter;
    }

    public DataPartition setFilter(FileFilter filter) {
        this.fileFilter = filter;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getThisPart());
        sb.append(" copy locations: {");
        for (int copyindex = 0; copyindex < this.getCopyCount(); ++copyindex) {
            if (copyindex > 0) {
                sb.append(", ");
            }
            sb.append(this.getCopyIP(copyindex));
        }
        sb.append("} :");
        sb.append(this.getPort());
        return sb.toString();
    }

    public static DataPartition[] createPartitions(DFUFilePartWrapper[] dfupartcopies, ClusterRemapper clusterremapper, int max_parts, String fileAccessBlob) throws HpccFileException {
        return DataPartition.createPartitions(dfupartcopies, clusterremapper, max_parts, FileFilter.nullFilter(), fileAccessBlob);
    }

    public static DataPartition[] createPartitions(DFUFilePartWrapper[] dfuparts, ClusterRemapper clusterremapper, int max_parts, FileFilter filter, String fileAccessBlob) throws HpccFileException {
        return DataPartition.createPartitions(dfuparts, clusterremapper, max_parts, FileFilter.nullFilter(), fileAccessBlob, FileType.FLAT);
    }

    public static DataPartition[] createPartitions(DFUFilePartWrapper[] dfuparts, ClusterRemapper clusterremapper, int max_parts, FileFilter filter, String fileAccessBlob, FileType fileType) throws HpccFileException {
        DataPartition[] rslt = new DataPartition[dfuparts.length];
        try {
            for (int i = 0; i < dfuparts.length; ++i) {
                int numCopies = dfuparts[i].getCopies().length;
                String[] copyPaths = new String[numCopies];
                for (int j = 0; j < numCopies; ++j) {
                    copyPaths[j] = dfuparts[i].getCopies()[j].getCopyPath();
                }
                DataPartition new_dp = new DataPartition(clusterremapper.reviseIPs(dfuparts[i].getCopies()), copyPaths, dfuparts[i].getPartIndex(), dfuparts.length, clusterremapper.revisePort(null), clusterremapper.getUsesSSLConnection(null), filter, fileAccessBlob, fileType);
                new_dp.isTLK = dfuparts[i].isTopLevelKey();
                rslt[i] = new_dp;
            }
        }
        catch (Exception e) {
            throw new HpccFileException("Could not create DataPartition!\n" + e.getMessage());
        }
        return rslt;
    }

    public int index() {
        return this.this_part - 1;
    }

    public boolean isTLK() {
        return this.isTLK;
    }

    public static enum FileType {
        FLAT("disk", true),
        INDEX("index", true),
        INDEX_LOCAL("indexlocal", true),
        INDEX_PARTITIONED("indexpartitioned", true),
        JSON("json", true),
        CSV("csv", false),
        XML("xml", false);

        private String name = null;
        private boolean typeCanBeDeduced = false;

        private FileType(String type, boolean deduced) {
            this.name = type;
            this.typeCanBeDeduced = deduced;
        }

        public String toString() {
            return this.name;
        }

        public boolean typeCanBeDeduced() {
            return this.typeCanBeDeduced;
        }

        public static FileType fromWrappedFileType(DFUFileTypeWrapper wrappedType) throws Exception {
            switch (wrappedType) {
                case Flat: {
                    return FLAT;
                }
                case Index: {
                    return INDEX;
                }
                case Xml: {
                    return XML;
                }
                case Csv: {
                    return CSV;
                }
                case Json: {
                    return JSON;
                }
                case IndexLocal: {
                    return INDEX_LOCAL;
                }
                case IndexPartitioned: {
                    return INDEX_PARTITIONED;
                }
            }
            throw new Exception("Unknown file type: " + wrappedType);
        }
    }
}

