/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;

public class ColumnPruner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fieldListString;
    private HashMap<String, SelectedFieldInfo> selectedFieldMap = null;

    public String getFieldListString() {
        return this.fieldListString;
    }

    public ColumnPruner(String commaSepFieldNamelist) {
        this.fieldListString = commaSepFieldNamelist;
        this.selectedFieldMap = new HashMap();
        String[] selectedFields = this.fieldListString.split(",");
        for (int i = 0; i < selectedFields.length; ++i) {
            String fieldPath = selectedFields[i].trim();
            if (fieldPath.isEmpty()) continue;
            String curPath = "";
            String[] pathComponents = fieldPath.split("\\.");
            for (int j = 0; j < pathComponents.length; ++j) {
                SelectedFieldInfo fieldInfo;
                String component = pathComponents[j].toLowerCase();
                if (j != 0) {
                    curPath = curPath + ".";
                }
                if ((fieldInfo = this.selectedFieldMap.get(curPath = curPath + component.trim())) == null) {
                    fieldInfo = new SelectedFieldInfo();
                    fieldInfo.name = component;
                    this.selectedFieldMap.put(curPath, fieldInfo);
                }
                boolean shouldCullChildren = j < pathComponents.length - 1;
                fieldInfo.shouldCullChildren = fieldInfo.shouldCullChildren || shouldCullChildren;
            }
        }
    }

    public FieldDef pruneRecordDefinition(FieldDef originalRD) throws Exception {
        if (this.selectedFieldMap.size() == 0) {
            return originalRD;
        }
        ArrayList<FieldDef> selectedFields = new ArrayList<FieldDef>();
        for (int i = 0; i < originalRD.getNumDefs(); ++i) {
            String fieldPath;
            FieldDef childDef = originalRD.getDef(i);
            FieldDef prunedFieldDef = this.pruneFieldDefinition(childDef, fieldPath = childDef.getFieldName().trim().toLowerCase());
            if (prunedFieldDef == null) continue;
            selectedFields.add(prunedFieldDef);
        }
        FieldDef ret = new FieldDef(originalRD);
        ret.setDefs(selectedFields.toArray(new FieldDef[0]));
        if (ret.getNumDefs() == 0) {
            throw new Exception("Error pruning record defintion. No fields were selected for field list: " + this.fieldListString);
        }
        return ret;
    }

    private FieldDef pruneFieldDefinition(FieldDef originalRecordDef, String path) {
        SelectedFieldInfo fieldInfo = this.selectedFieldMap.get(path);
        if (fieldInfo == null) {
            return null;
        }
        if (!fieldInfo.shouldCullChildren) {
            return originalRecordDef;
        }
        if (originalRecordDef.getFieldType() == FieldType.DATASET) {
            FieldDef[] datasetRD = new FieldDef[]{this.pruneFieldDefinition(originalRecordDef.getDef(0), path)};
            FieldDef ret = new FieldDef(originalRecordDef);
            ret.setDefs(datasetRD);
            return ret;
        }
        ArrayList<FieldDef> selectedFields = new ArrayList<FieldDef>();
        for (int i = 0; i < originalRecordDef.getNumDefs(); ++i) {
            String fieldPath;
            FieldDef childDef = originalRecordDef.getDef(i);
            FieldDef prunedFieldDef = this.pruneFieldDefinition(childDef, fieldPath = path + "." + childDef.getFieldName().trim().toLowerCase());
            if (prunedFieldDef == null) continue;
            selectedFields.add(prunedFieldDef);
        }
        FieldDef ret = new FieldDef(originalRecordDef);
        ret.setDefs(selectedFields.toArray(new FieldDef[0]));
        return ret;
    }

    private class SelectedFieldInfo {
        String name = null;
        boolean shouldCullChildren = false;

        private SelectedFieldInfo() {
        }
    }
}

