/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.ecl.HpccSrcType;

public class AvroSchemaTranslator {
    public static FieldDef toHPCC(Schema schema, String fieldName) throws Exception {
        FieldDef ret = null;
        switch (schema.getType()) {
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                FieldDef[] elementDef = new FieldDef[]{AvroSchemaTranslator.toHPCC(elementSchema, elementSchema.getName())};
                if (elementDef[0].getFieldType() == FieldType.RECORD) {
                    ret = new FieldDef(fieldName, FieldType.DATASET, "DATASET", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, elementDef);
                    break;
                }
                ret = new FieldDef(fieldName, FieldType.SET, "SET", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, elementDef);
                break;
            }
            case BOOLEAN: {
                ret = new FieldDef(fieldName, FieldType.BOOLEAN, "BOOL", 1L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case BYTES: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    throw new Exception("Invalid field type. Non-fixed length decimal values are currently unsupported.");
                }
                ret = new FieldDef(fieldName, FieldType.BINARY, "BINARY", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case DOUBLE: {
                ret = new FieldDef(fieldName, FieldType.REAL, "REAL8", 8L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case ENUM: {
                List enumSymbols = schema.getEnumSymbols();
                int bytesNeeded = 1;
                if (enumSymbols.size() >= 127) {
                    bytesNeeded = 2;
                    if (enumSymbols.size() >= Short.MAX_VALUE) {
                        throw new Exception("Enum has too many symbols, a max of 32767 symbols are supported.");
                    }
                }
                ret = new FieldDef(fieldName, FieldType.INTEGER, "INTEGER" + bytesNeeded, (long)bytesNeeded, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case FIXED: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimalInfo = (LogicalTypes.Decimal)schema.getLogicalType();
                    ret = new FieldDef(fieldName, FieldType.DECIMAL, "DECIMAL", 1L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                    ret.setPrecision(decimalInfo.getPrecision());
                    ret.setScale(decimalInfo.getScale());
                    break;
                }
                if (schema.getLogicalType().getName().equals("duration")) {
                    ret = new FieldDef(fieldName, FieldType.INTEGER, "INTEGER8", 8L, true, true, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                    break;
                }
                ret = new FieldDef(fieldName, FieldType.BINARY, "BINARY", (long)schema.getFixedSize(), true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case FLOAT: {
                ret = new FieldDef(fieldName, FieldType.REAL, "REAL4", 4L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case INT: {
                ret = new FieldDef(fieldName, FieldType.INTEGER, "INTEGER4", 4L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case LONG: {
                ret = new FieldDef(fieldName, FieldType.INTEGER, "INTEGER8", 8L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case MAP: {
                FieldDef[] childFields = new FieldDef[]{new FieldDef("key", FieldType.STRING, "UTF8", 0L, false, false, HpccSrcType.UTF8, new FieldDef[0]), AvroSchemaTranslator.toHPCC(schema.getValueType(), "value")};
                FieldDef[] elementDef = new FieldDef[]{new FieldDef("KeyValueRecord", FieldType.RECORD, "RECORD", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, childFields)};
                ret = new FieldDef(fieldName, FieldType.DATASET, "DATASET", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, elementDef);
                break;
            }
            case NULL: {
                ret = new FieldDef(fieldName, FieldType.BOOLEAN, "BOOL", 1L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                break;
            }
            case RECORD: {
                int i;
                List fields = schema.getFields();
                boolean hasNullableFields = false;
                for (Schema.Field field : fields) {
                    if (field.schema().getType() != Schema.Type.UNION) continue;
                    for (Schema unionType : field.schema().getTypes()) {
                        if (unionType.getType() != Schema.Type.NULL) continue;
                        hasNullableFields = true;
                    }
                }
                int numNullBitFields = 0;
                if (hasNullableFields) {
                    numNullBitFields = (fields.size() + 63) / 64;
                }
                FieldDef[] childFields = new FieldDef[fields.size() + numNullBitFields];
                for (i = 0; i < fields.size(); ++i) {
                    Schema.Field field = (Schema.Field)fields.get(i);
                    childFields[i] = AvroSchemaTranslator.toHPCC(field.schema(), field.name());
                }
                for (i = 0; i < numNullBitFields; ++i) {
                    childFields[fields.size() + i] = new FieldDef("nullBitField" + i, FieldType.INTEGER, "INTEGER8", 8L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
                }
                ret = new FieldDef(fieldName, FieldType.RECORD, "RECORD", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, childFields);
                break;
            }
            case STRING: {
                ret = new FieldDef(fieldName, FieldType.STRING, "UTF8", 0L, false, false, HpccSrcType.UTF8, new FieldDef[0]);
                break;
            }
            case UNION: {
                boolean isSimpleNullable;
                List unionTypes = schema.getTypes();
                boolean isNullable = false;
                ArrayList<Schema> types = new ArrayList<Schema>();
                for (Schema type : unionTypes) {
                    if (type.getType() == Schema.Type.UNION) {
                        isNullable = true;
                        continue;
                    }
                    types.add(type);
                }
                boolean bl = isSimpleNullable = types.size() == 1 && isNullable;
                if (isSimpleNullable) {
                    ret = AvroSchemaTranslator.toHPCC((Schema)types.get(0), fieldName);
                    break;
                }
                ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
                for (int i = 0; i < types.size(); ++i) {
                    Schema childSchema = (Schema)types.get(i);
                    childFields.add(new Schema.Field(childSchema.getName() + "Type", childSchema, "", null));
                }
                childFields.add(new Schema.Field("unionType", Schema.create((Schema.Type)Schema.Type.INT), "", null));
                boolean isError = false;
                ret = AvroSchemaTranslator.toHPCC(Schema.createRecord((String)(fieldName + "Rec"), (String)"", (String)"", (boolean)isError), fieldName);
                break;
            }
        }
        return ret;
    }

    public static Schema toAvro(FieldDef fd) throws Exception {
        switch (fd.getFieldType()) {
            case VAR_STRING: 
            case STRING: 
            case CHAR: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case INTEGER: {
                if (fd.getDataLen() <= 4L) {
                    return Schema.create((Schema.Type)Schema.Type.INT);
                }
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case BINARY: {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case REAL: {
                if (fd.getDataLen() <= 4L) {
                    return Schema.create((Schema.Type)Schema.Type.FLOAT);
                }
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case DECIMAL: {
                Conversions.DecimalConversion conv = new Conversions.DecimalConversion();
                return conv.getRecommendedSchema();
            }
            case SET: 
            case DATASET: {
                Schema childSchema = AvroSchemaTranslator.toAvro(fd.getDef(0));
                return Schema.createArray((Schema)childSchema);
            }
            case RECORD: {
                ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
                for (int i = 0; i < fd.getNumDefs(); ++i) {
                    FieldDef childField = fd.getDef(i);
                    fields.add(new Schema.Field(childField.getFieldName(), AvroSchemaTranslator.toAvro(childField), null, null));
                }
                Boolean isError = false;
                Schema recSchema = Schema.createRecord((String)fd.getFieldName(), (String)"", (String)"", (boolean)isError, fields);
                if (isError.booleanValue()) {
                    throw new Exception("AvroSchemaTranslator: Error translation record def.");
                }
                recSchema.addAlias(fd.getFieldName());
                return recSchema;
            }
        }
        throw new Exception("AvroSchemaTranslator: Unknown field type");
    }
}

